  <!-- Footer -->
  <footer class="footer">
      <p>&copy; Paroki Santa Maria Blitar 2025</p>
    </footer>
    
    <script src="<?= base_url('asset/website/js/'); ?>web_scripts.js"></script>
    <script>
      const carousel = document.querySelector(".carousel-container");
      const prevBtn = document.querySelector(".prev-btn");
      const nextBtn = document.querySelector(".next-btn");
      const cards = document.querySelectorAll(".announcement-card");
      const modal = document.getElementById("announcementModal");
      const modalImage = document.getElementById("modalImage");
      const modalTitle = document.getElementById("modalTitle");
      const modalDesc1 = document.getElementById("modalDesc1");
      const modalDesc2 = document.getElementById("modalDesc2");
      const modalWhatsapp = document.getElementById("modalWhatsapp");
      const closeModal = document.getElementById("closeModal");

      let currentIndex = 0;
      const totalCards = cards.length;

      // Fungsi untuk menghitung lebar card dan jumlah card yang terlihat
      function getCardWidth() {
        return cards[0].offsetWidth + 20;
      }

      function getVisibleCards() {
        const containerWidth = carousel.clientWidth;
        const cardWidth = getCardWidth();
        if (window.innerWidth <= 480) return 1;
        if (window.innerWidth <= 790) return 2;
        return Math.min(3, Math.floor(containerWidth / cardWidth)) || 1; // Maksimum 3 card
      }

      // Fungsi untuk update posisi carousel
      function updateCarousel() {
        const cardWidth = getCardWidth();
        const visibleCards = getVisibleCards();
        carousel.scrollTo({
          left: currentIndex * cardWidth,
          behavior: "smooth",
        });

        prevBtn.style.display = currentIndex <= 0 ? "none" : "block";
        nextBtn.style.display =
          currentIndex >= totalCards - visibleCards ? "none" : "block";
      }

      // Navigasi carousel
      nextBtn.addEventListener("click", () => {
        const visibleCards = getVisibleCards();
        if (currentIndex < totalCards - visibleCards) {
          currentIndex += 1;
          updateCarousel();
        }
      });

      prevBtn.addEventListener("click", () => {
        if (currentIndex > 0) {
          currentIndex -= 1;
          updateCarousel();
        }
      });

      window.addEventListener("resize", updateCarousel);

      // Modal dan link functionality
      cards.forEach((card) => {
        card.addEventListener("click", (e) => {
          if (e.target.classList.contains("read-more-btn")) return;

          modalImage.src = card.dataset.image;
          modalTitle.textContent = card.dataset.title;
          modalDesc1.textContent = card.dataset.desc1;
          modalDesc2.textContent = card.dataset.desc2;
          modalWhatsapp.href = card.dataset.whatsapp;
          modal.style.display = "flex";
        });

        card.querySelector(".read-more-btn").addEventListener("click", (e) => {
          e.stopPropagation();
          window.open(card.dataset.link, "_blank");
        });
      });

      // Tutup modal
      closeModal.addEventListener("click", () => {
        modal.style.display = "none";
      });

      modal.addEventListener("click", (e) => {
        if (e.target === modal) {
          modal.style.display = "none";
        }
      });

      // Inisialisasi
      updateCarousel();
    </script>

<script>
    document.getElementById('loginFormBtn').addEventListener('click', function() {
        document.getElementById('modalChoice').style.display = 'none';
        document.getElementById('modalLogin').style.display = 'block';
    });

    document.getElementById('externalLinkBtn').addEventListener('click', function() {
        window.location.href = 'URL_DASHBOARD_DATA_UMAT'; // Ganti dengan URL yang sesuai
    });

    document.querySelector('.close').addEventListener('click', function() {
        document.getElementById('loginModal').style.display = 'none';
    });

    // Tampilkan modal saat halaman dimuat (opsional)
    // document.getElementById('loginModal').style.display = 'block';
</script>
  </body>
</html>
