<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-4 text-gray-800"><?= $title; ?></h1>
    <div class="row">
        <div class="col-lg">
            <!-- Tombol Add New Sejarah -->
            <a href="" class="btn btn-primary mb-3" data-toggle="modal" data-target="#newSejarahModal">Add New Sejarah</a>

            <!-- Form Pencarian dan Filter Status -->
            <form method="get" action="<?= base_url('d_sejarah'); ?>" class="mb-3">
                <div class="row">
                    <div class="col-md-6">
                        <div class="input-group">
                            <input type="text" name="search" class="form-control" placeholder="Cari sejarah..." value="<?= isset($_GET['search']) ? html_escape($_GET['search']) : ''; ?>">
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="submit">Search</button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <select name="status" class="form-control" onchange="this.form.submit()">
                            <option value="all" <?= isset($_GET['status']) && $_GET['status'] == 'all' ? 'selected' : ''; ?>>All</option>
                            <option value="pending" <?= isset($_GET['status']) && $_GET['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                            <option value="public" <?= isset($_GET['status']) && $_GET['status'] == 'public' ? 'selected' : ''; ?>>Public</option>
                        </select>
                    </div>
                </div>
            </form>

            <table class="table table-hover" id="sejarahTable">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col" class="sortable" data-sort="tahun">Tahun <i class="fas fa-sort"></i></th>
                        <th scope="col" class="sortable" data-sort="kategori">Kategori <i class="fas fa-sort"></i></th>
                        <th scope="col">Isi</th>
                        <th scope="col">Status</th>
                        <th scope="col">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; ?>
                    <?php foreach ($sejarah as $sej) : ?>
                    <tr>
                        <th scope="row" style="cursor: pointer;" data-toggle="modal" data-target="#detailSejarahModal<?= $sej['id']; ?>"><?= $i; ?></th>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailSejarahModal<?= $sej['id']; ?>" data-tahun="<?= html_escape($sej['tahun']); ?>"><?= html_escape($sej['tahun']); ?></td>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailSejarahModal<?= $sej['id']; ?>" data-kategori="<?= html_escape($sej['kategori']); ?>"><?= html_escape($sej['kategori']); ?></td>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailSejarahModal<?= $sej['id']; ?>">
                            <?php echo strlen($sej['isi']) > 30 ? html_escape(substr($sej['isi'], 0, 30)) . '...' : html_escape($sej['isi']); ?>
                        </td>
                        <td>
                            <?php if ($user['role_id'] == 1) : ?>
                                <?php if ($sej['role'] == 0) : ?>
                                    <a href="<?= base_url('d_sejarah/publish/') . $sej['id']; ?>" class="badge badge-warning" onclick="return confirm('Apakah Anda yakin ingin mempublikasikan data ini?')">Pending</a>
                                <?php elseif ($sej['role'] == 1) : ?>
                                    <span class="badge badge-success">Public</span>
                                <?php endif; ?>
                            <?php else : ?>
                                <?php if ($sej['role'] == 0) : ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php elseif ($sej['role'] == 1) : ?>
                                    <span class="badge badge-success">Public</span>
                                <?php endif; ?>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="<?= base_url('d_sejarah/edit/') . $sej['id']; ?>" class="badge badge-success">Edit</a>
                            <a href="<?= base_url('d_sejarah/delete/') . $sej['id']; ?>" class="badge badge-danger" onclick="return confirm('Apakah Anda yakin ingin menghapus data ini?')">Delete</a>
                        </td>
                    </tr>

                    <!-- Modal Detail Sejarah -->
                    <div class="modal fade" id="detailSejarahModal<?= $sej['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="detailSejarahModalLabel<?= $sej['id']; ?>" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h2 class="modal-title w-100" id="detailSejarahModalLabel<?= $sej['id']; ?>">
                                        <?= html_escape($sej['tahun'] . ' - ' . $sej['kategori']); ?>
                                    </h2>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">×</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <p class="text-muted small mb-3">
                                        Tanggal Penulisan: <?= date('d F Y', strtotime($sej['tanggal_penulisan'])); ?>
                                    </p>
                                    <div class="sejarah-isi">
                                        <?= nl2br(html_escape($sej['isi'])); ?>
                                    </div>
                                    <?php if (!empty($sej['gambar_sejarah'])) : ?>
                                        <img src="<?= base_url('asset/img/sejarah/') . $sej['gambar_sejarah']; ?>" class="img-fluid mt-3" alt="Gambar Sejarah">
                                    <?php endif; ?>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php $i++; ?>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal Tambah Sejarah -->
    <div class="modal fade" id="newSejarahModal" tabindex="-1" role="dialog" aria-labelledby="newSejarahModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="newSejarahModalLabel">Tambah Sejarah Baru</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <form action="<?= base_url('d_sejarah/tambah'); ?>" method="post" enctype="multipart/form-data">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="tahun">Tahun</label>
                            <input type="text" class="form-control" id="tahun" name="tahun" placeholder="Masukkan tahun kejadian" required>
                        </div>
                        <div class="form-group">
                            <label for="kategori">Kategori</label>
                            <select class="form-control" id="kategori" name="kategori" required>
                                <option value="">-- Pilih Kategori --</option>
                                <?php foreach ($kategori_list as $kat) : ?>
                                    <option value="<?= html_escape($kat['kategori_format']); ?>"><?= html_escape($kat['kategori_format']); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="isi">Isi</label>
                            <textarea class="form-control" id="isi" name="isi" rows="5" placeholder="Masukkan isi sejarah" required></textarea>
                        </div>
                        <div class="form-group">
                            <label for="gambar_sejarah">Gambar Sejarah (opsional)</label>
                            <input type="file" class="form-control-file" id="gambar_sejarah" name="gambar_sejarah">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Tambah</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Script Sorting -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const table = document.getElementById('sejarahTable');
    const headers = table.querySelectorAll('.sortable');
    let sortDirection = {};

    headers.forEach(header => {
        header.addEventListener('click', () => {
            const sortKey = header.getAttribute('data-sort');
            const isAscending = sortDirection[sortKey] === 'asc';
            sortDirection[sortKey] = isAscending ? 'desc' : 'asc';

            sortTable(sortKey, !isAscending);
        });
    });

    function sortTable(key, ascending) {
        const tbody = table.querySelector('tbody');
        const rows = Array.from(tbody.querySelectorAll('tr'));

        rows.sort((a, b) => {
            let aValue = a.querySelector(`td[data-${key}]`).getAttribute(`data-${key}`);
            let bValue = b.querySelector(`td[data-${key}]`).getAttribute(`data-${key}`);

            if (!aValue) aValue = '';
            if (!bValue) bValue = '';

            return ascending 
                ? aValue.localeCompare(bValue) 
                : bValue.localeCompare(aValue);
        });

        rows.forEach(row => tbody.appendChild(row));

        headers.forEach(h => {
            const icon = h.querySelector('i');
            if (h.getAttribute('data-sort') === key) {
                icon.className = ascending ? 'fas fa-sort-up' : 'fas fa-sort-down';
            } else {
                icon.className = 'fas fa-sort';
            }
        });
    }
});
</script>