<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-4 text-gray-800"><?= $title; ?></h1>

    <div class="row">
        <div class="col-lg-8">
            <?php if ($this->session->flashdata('message')) : ?>
                <?= $this->session->flashdata('message'); ?>
            <?php endif; ?>

            <div class="card">
                <div class="card-header">
                    Form Edit Pengumuman
                </div>
                <div class="card-body">
                    <form action="<?= base_url('d_pengumuman/edit/' . $pengumuman['id']); ?>" method="post" enctype="multipart/form-data">
                        <div class="form-group">
                            <label for="judul">Judul</label>
                            <input type="text" class="form-control" id="judul" name="judul" value="<?= $pengumuman['judul']; ?>" required>
                            <?= form_error('judul', '<small class="text-danger">', '</small>'); ?>
                        </div>
                        <div class="form-group">
                            <label for="tanggal_kegiatan">Tanggal Kegiatan</label>
                            <input type="date" class="form-control" id="tanggal_kegiatan" name="tanggal_kegiatan" value="<?= $pengumuman['tanggal_kegiatan']; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="jam_kegiatan">Jam Kegiatan</label>
                            <input type="time" class="form-control" id="jam_kegiatan" name="jam_kegiatan" value="<?= $pengumuman['jam_kegiatan']; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="tempat_kegiatan">Tempat Kegiatan</label>
                            <input type="text" class="form-control" id="tempat_kegiatan" name="tempat_kegiatan" value="<?= $pengumuman['tempat_kegiatan']; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="reservasi_fasilitas">Reservasi Fasilitas</label>
                            <input type="text" class="form-control" id="reservasi_fasilitas" name="reservasi_fasilitas" value="<?= $pengumuman['reservasi_fasilitas']; ?>">
                        </div>
                        <div class="form-group">
                            <label for="kontak_cs">Kontak CS</label>
                            <input type="text" class="form-control" id="kontak_cs" name="kontak_cs" value="<?= $pengumuman['kontak_cs']; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="kategori">Kategori</label>
                            <select name="kategori" id="kategori" class="form-control" required>
                                <?php foreach ($kategori as $kat) : ?>
                                    <option value="<?= $kat['nama']; ?>" <?= $kat['nama'] == $pengumuman['kategori'] ? 'selected' : ''; ?>><?= $kat['nama']; ?></option>
                                <?php endforeach; ?>
                            </select>
                            <?= form_error('kategori', '<small class="text-danger">', '</small>'); ?>
                        </div>
                        <div class="form-group">
                            <label for="gambar">Upload Gambar</label>
                            <?php if ($pengumuman['upload_gambar']) : ?>
                                <p>Gambar Saat Ini: <img src="<?= base_url('asset/img/pengumuman/' . $pengumuman['upload_gambar']); ?>" alt="Current Image" width="100"></p>
                            <?php endif; ?>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="gambar" name="gambar">
                                <label class="custom-file-label" for="gambar">Choose file</label>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                        <a href="<?= base_url('d_pengumuman'); ?>" class="btn btn-secondary">Kembali</a>
                    </form>
                </div>
            </div>
        </div>
    </div>

</div>
<!-- /.container-fluid -->

<script>
    // Update label file input saat memilih file
    $('.custom-file-input').on('change', function() {
        let fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').addClass("selected").html(fileName);
    });
</script>