<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-4 text-gray-800"><?= $title; ?></h1>

    <div class="row">
        <div class="col-lg-8">
            <?php if ($this->session->flashdata('message')) : ?>
                <?= $this->session->flashdata('message'); ?>
            <?php endif; ?>

            <div class="card">
                <div class="card-header">
                    Form Edit Pelayan Pastoral
                </div>
                <div class="card-body">
                    <form action="<?= base_url('d_pelayan_pastoral/edit/' . $pelayan['id']); ?>" method="post" enctype="multipart/form-data">
                        <div class="form-group">
                            <label for="nama_lengkap">Nama Lengkap <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="nama_lengkap" name="nama_lengkap" value="<?= $pelayan['nama_lengkap']; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="jabatan">Jabatan <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="jabatan" name="jabatan" value="<?= $pelayan['jabatan']; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="tempat_lahir">Tempat Lahir</label>
                            <input type="text" class="form-control" id="tempat_lahir" name="tempat_lahir" value="<?= $pelayan['tempat_lahir']; ?>">
                        </div>
                        <div class="form-group">
                            <label for="tarekat">Tarekat</label>
                            <input type="text" class="form-control" id="tarekat" name="tarekat" value="<?= $pelayan['tarekat']; ?>">
                        </div>
                        <div class="form-group">
                            <label for="tempat_tahbisan">Tempat Tahbisan</label>
                            <input type="text" class="form-control" id="tempat_tahbisan" name="tempat_tahbisan" value="<?= $pelayan['tempat_tahbisan']; ?>">
                        </div>
                        <div class="form-group">
                            <label for="tanggal_tahbisan">Tanggal Tahbisan</label>
                            <input type="date" class="form-control" id="tanggal_tahbisan" name="tanggal_tahbisan" value="<?= $pelayan['tanggal_tahbisan']; ?>">
                        </div>
                        <div class="form-group">
                            <label for="tanggal_mulai">Tanggal Mulai <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" id="tanggal_mulai" name="tanggal_mulai" value="<?= $pelayan['tanggal_mulai']; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="tanggal_selesai">Tanggal Selesai</label>
                            <input type="date" class="form-control" id="tanggal_selesai" name="tanggal_selesai" value="<?= $pelayan['tanggal_selesai']; ?>">
                        </div>
                        <div class="form-group">
                            <label for="deskripsi">Deskripsi</label>
                            <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5"><?= $pelayan['deskripsi']; ?></textarea>
                        </div>
                        <div class="form-group">
                            <label for="link_foto">Upload Foto</label>
                            <?php if ($pelayan['link_foto']) : ?>
                                <p>Foto Saat Ini: <img src="<?= base_url('asset/img/pelayan_pastoral/' . $pelayan['link_foto']); ?>" alt="Current Image" width="100"></p>
                            <?php endif; ?>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="link_foto" name="link_foto">
                                <label class="custom-file-label" for="link_foto">Choose file</label>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                        <a href="<?= base_url('d_pelayan_pastoral'); ?>" class="btn btn-secondary">Kembali</a>
                    </form>
                </div>
            </div>
        </div>
    </div>

</div>
<!-- /.container-fluid -->

<script>
    $('.custom-file-input').on('change', function() {
        let fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').addClass("selected").html(fileName);
    });
</script>