<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-4 text-gray-800"><?= $title; ?></h1>

    <div class="row">
        <div class="col-lg">
            <a href="" class="btn btn-primary mb-3" data-toggle="modal" data-target="#newPanggilanModal">Add New Data</a>

            <!-- Form Pencarian dan Filter Status -->
            <form method="get" action="<?= base_url('d_panggilan'); ?>" class="mb-3">
                <div class="row">
                    <div class="col-md-6">
                        <div class="input-group">
                            <input type="text" name="search" class="form-control" placeholder="Cari data panggilan..." value="<?= isset($_GET['search']) ? $_GET['search'] : ''; ?>">
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="submit">Search</button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <select name="status" class="form-control" onchange="this.form.submit()">
                            <option value="all" <?= isset($_GET['status']) && $_GET['status'] == 'all' ? 'selected' : ''; ?>>All</option>
                            <option value="pending" <?= isset($_GET['status']) && $_GET['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                            <option value="public" <?= isset($_GET['status']) && $_GET['status'] == 'public' ? 'selected' : ''; ?>>Public</option>
                        </select>
                    </div>
                </div>
            </form>

            <table class="table table-hover">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Nama Lengkap</th>
                        <th scope="col">Jabatan</th>
                        <th scope="col">Tahun Tahbisan</th>
                        <th scope="col">Tarekat</th>
                        <th scope="col">Status</th>
                        <th scope="col">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; ?>
                    <?php foreach ($panggilan as $p) : ?>
                    <tr>
                        <th scope="row" style="cursor: pointer;" data-toggle="modal" data-target="#detailPanggilanModal<?= $p['id']; ?>"><?= $i; ?></th>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailPanggilanModal<?= $p['id']; ?>"><?= $p['nama_lengkap']; ?></td>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailPanggilanModal<?= $p['id']; ?>"><?= $p['jabatan']; ?></td>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailPanggilanModal<?= $p['id']; ?>"><?= date('Y', strtotime($p['tanggal_tahbisan'])); ?></td>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailPanggilanModal<?= $p['id']; ?>"><?= $p['tarekat']; ?></td>
                        <td>
                            <?php if ($user['role_id'] == 1) : ?>
                                <?php if ($p['role'] == 0) : ?>
                                    <a href="<?= base_url('d_panggilan/publish/') . $p['id']; ?>" class="badge badge-warning" onclick="return confirm('Apakah Anda yakin ingin mempublikasikan data ini?')">Pending</a>
                                <?php elseif ($p['role'] == 1) : ?>
                                    <span class="badge badge-success">Public</span>
                                <?php endif; ?>
                            <?php else : ?>
                                <?php if ($p['role'] == 0) : ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php elseif ($p['role'] == 1) : ?>
                                    <span class="badge badge-success">Public</span>
                                <?php endif; ?>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="<?= base_url('d_panggilan/edit/') . $p['id']; ?>" class="badge badge-success">Edit</a>
                            <a href="<?= base_url('d_panggilan/delete/') . $p['id']; ?>" class="badge badge-danger" onclick="return confirm('Apakah Anda yakin ingin menghapus data ini?')">Delete</a>
                        </td>
                    </tr>

                    <!-- Modal Detail Panggilan -->
                    <div class="modal fade" id="detailPanggilanModal<?= $p['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="detailPanggilanModalLabel<?= $p['id']; ?>" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h2 class="modal-title w-100" id="detailPanggilanModalLabel<?= $p['id']; ?>"><?= $p['nama_lengkap']; ?></h2>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">×</span>
                                    </button>
                                </div>
                                <div class="modal-body text-center">
                                    <p class="text-muted small mb-2"><?= date('d F Y H:i', strtotime($p['tanggal_update'])); ?></p>
                                    <?php if (!empty($p['link_foto'])) : ?>
                                        <img src="<?= base_url('asset/img/panggilan/') . $p['link_foto']; ?>" class="img-fluid mb-3" alt="<?= $p['nama_lengkap']; ?>" style="max-width: 300px; height: 300px; object-fit: cover;">
                                    <?php endif; ?>
                                    <div class="text-left">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <p><strong>Nama Panggilan</strong></p>
                                                <p><strong>Tempat Lahir</strong></p>
                                                <p><strong>Tarekat</strong></p>
                                                <p><strong>Tanggal Tahbisan</strong></p>
                                                <p><strong>Tempat Tahbisan</strong></p>
                                                <p><strong>Nama Ayah</strong></p>
                                                <p><strong>Nama Ibu</strong></p>
                                                <p><strong>Domisili Tinggal</strong></p>
                                                <p><strong>Jabatan</strong></p>
                                                <p><strong>Alamat Tinggal</strong></p>
                                                <p><strong>Deskripsi</strong></p>
                                            </div>
                                            <div class="col-md-9">
                                                <p>: <?= $p['nama_panggilan']; ?></p>
                                                <p>: <?= $p['tempat_lahir']; ?>, <?= $p['tanggal_lahir']; ?></p>
                                                <p>: <?= $p['tarekat']; ?></p>
                                                <p>: <?= $p['tanggal_tahbisan']; ?></p>
                                                <p>: <?= $p['tempat_tahbisan']; ?></p>
                                                <p>: <?= $p['nama_ayah']; ?></p>
                                                <p>: <?= $p['nama_ibu']; ?></p>
                                                <p>: <?= $p['domisili_tinggal']; ?></p>
                                                <p>: <?= $p['jabatan']; ?></p>
                                                <p>: <?= $p['alamat_tinggal']; ?></p>
                                                <p>: </p>
                                            </div>
                                        </div>
                                        <p><?= nl2br($p['deskripsi']); ?></p>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php $i++; ?>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal Tambah Panggilan -->
    <div class="modal fade" id="newPanggilanModal" tabindex="-1" role="dialog" aria-labelledby="newPanggilanModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="newPanggilanModalLabel">Add New Panggilan</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <form action="<?= base_url('d_panggilan'); ?>" method="post" enctype="multipart/form-data">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="nama_lengkap">Nama Lengkap <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="nama_lengkap" name="nama_lengkap" required>
                        </div>
                        <div class="form-group">
                            <label for="nama_panggilan">Nama Panggilan</label>
                            <input type="text" class="form-control" id="nama_panggilan" name="nama_panggilan">
                        </div>
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-6">
                                    <label for="tempat_lahir">Tempat Lahir</label>
                                    <input type="text" class="form-control" id="tempat_lahir" name="tempat_lahir">
                                </div>
                                <div class="col-md-6">
                                    <label for="tanggal_lahir">Tanggal Lahir </label>
                                    <input type="date" class="form-control" id="tanggal_lahir" name="tanggal_lahir">
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="tarekat">Tarekat</label>
                            <input type="text" class="form-control" id="tarekat" name="tarekat">
                        </div>
                        <div class="form-group">
                            <label for="tempat_tahbisan">Tempat Tahbisan</label>
                            <input type="text" class="form-control" id="tempat_tahbisan" name="tempat_tahbisan">
                        </div>
                        <div class="form-group">
                            <label for="jabatan">Jabatan</label>
                            <input type="text" class="form-control" id="jabatan" name="jabatan">
                        </div>
                        <div class="form-group">
                            <label for="tanggal_tahbisan">Tanggal Tahbisan</label>
                            <input type="date" class="form-control" id="tanggal_tahbisan" name="tanggal_tahbisan">
                        </div>
                        <div class="form-group">
                            <label for="nama_ayah">Nama Ayah</label>
                            <input type="text" class="form-control" id="nama_ayah" name="nama_ayah">
                        </div>
                        <div class="form-group">
                            <label for="nama_ibu">Nama Ibu</label>
                            <input type="text" class="form-control" id="nama_ibu" name="nama_ibu">
                        </div>
                        <div class="form-group">
                            <label for="domisili_tinggal">Domisili Tinggal <span class="text-danger">*</span></label>
                            <select name="domisili_tinggal" id="domisili_tinggal" class="form-control" required>
                                <option value="">Pilih Domisili</option>
                                <?php foreach ($lingk_stasi as $ls) : ?>
                                    <?php
                                    $domisili = ($ls['kategori'] == 'lingkungan') 
                                        ? $ls['kategori'] . ' ' . $ls['nama_pelindung'] 
                                        : $ls['kategori'] . ' ' . $ls['nama_pelindung'] . ' - ' . $ls['lokasi'];
                                    ?>
                                    <option value="<?= $domisili; ?>"><?= $domisili; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="alamat_tinggal">Alamat Tinggal</label>
                            <input type="text" class="form-control" id="alamat_tinggal" name="alamat_tinggal">
                        </div>
                        <div class="form-group">
                            <label for="deskripsi">Deskripsi</label>
                            <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5"></textarea>
                        </div>
                        <div class="custom-file">
                            <label for="link_foto">Upload Foto</label>
                            <input type="file" class="custom-file-input" id="link_foto" name="link_foto">
                            <label class="custom-file-label" for="link_foto">Choose file</label>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Tambah</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- /.container-fluid -->

<script>
    $('.custom-file-input').on('change', function() {
        let fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').addClass("selected").html(fileName);
    });
</script>