<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-4 text-gray-800"><?= $title; ?></h1>

    <div class="row">
        <div class="col-lg-8">
            <?php if ($this->session->flashdata('message')) : ?>
                <?= $this->session->flashdata('message'); ?>
            <?php endif; ?>

            <div class="card">
                <div class="card-header">
                    Form Edit Panggilan
                </div>
                <div class="card-body">
                    <form action="<?= base_url('d_panggilan/edit/' . $panggilan['id']); ?>" method="post" enctype="multipart/form-data">
                        <div class="form-group">
                            <label for="nama_lengkap">Nama Lengkap <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="nama_lengkap" name="nama_lengkap" value="<?= $panggilan['nama_lengkap']; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="nama_panggilan">Nama Panggilan</label>
                            <input type="text" class="form-control" id="nama_panggilan" name="nama_panggilan" value="<?= $panggilan['nama_panggilan']; ?>">
                        </div>
                        <div class="form-group">
                            <label for="tempat_lahir">Tempat Lahir</label>
                            <input type="text" class="form-control" id="tempat_lahir" name="tempat_lahir" value="<?= $panggilan['tempat_lahir']; ?>">
                        </div>
                        <div class="form-group">
                            <label for="tanggal_lahir">Tanggal Lahir <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" id="tanggal_lahir" name="tanggal_lahir" value="<?= $panggilan['tanggal_lahir']; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="tarekat">Tarekat</label>
                            <input type="text" class="form-control" id="tarekat" name="tarekat" value="<?= $panggilan['tarekat']; ?>">
                        </div>
                        <div class="form-group">
                            <label for="jabatan">Jabatan</label>
                            <input type="text" class="form-control" id="jabatan" name="jabatan" value="<?= $panggilan['jabatan']; ?>">
                        </div>
                        <div class="form-group">
                            <label for="tanggal_tahbisan">Tanggal Tahbisan</label>
                            <input type="date" class="form-control" id="tanggal_tahbisan" name="tanggal_tahbisan" value="<?= $panggilan['tanggal_tahbisan']; ?>">
                        </div>
                        <div class="form-group">
                            <label for="tempat_tahbisan">Tempat Tahbisan</label>
                            <input type="text" class="form-control" id="tempat_tahbisan" name="tempat_tahbisan" value="<?= $panggilan['tempat_tahbisan']; ?>">
                        </div>
                        <div class="form-group">
                            <label for="nama_ayah">Nama Ayah</label>
                            <input type="text" class="form-control" id="nama_ayah" name="nama_ayah" value="<?= $panggilan['nama_ayah']; ?>">
                        </div>
                        <div class="form-group">
                            <label for="nama_ibu">Nama Ibu</label>
                            <input type="text" class="form-control" id="nama_ibu" name="nama_ibu" value="<?= $panggilan['nama_ibu']; ?>">
                        </div>
                        <div class="form-group">
                            <label for="domisili_tinggal">Domisili Tinggal <span class="text-danger">*</span></label>
                            <select name="domisili_tinggal" id="domisili_tinggal" class="form-control" required>
                                <option value="">Pilih Domisili</option>
                                <?php foreach ($lingk_stasi as $ls) : ?>
                                    <?php
                                    $domisili = ($ls['kategori'] == 'lingkungan') 
                                        ? $ls['kategori'] . ' ' . $ls['nama_pelindung'] 
                                        : $ls['kategori'] . ' ' . $ls['nama_pelindung'] . ' - ' . $ls['lokasi'];
                                    ?>
                                    <option value="<?= $domisili; ?>" <?= $panggilan['domisili_tinggal'] == $domisili ? 'selected' : ''; ?>><?= $domisili; ?></option>
                                <?php endforeach; ?>
                            </select>
                        <div class="form-group">
                            <label for="alamat_tinggal">Alamat Tinggal</label>
                            <input type="text" class="form-control" id="alamat_tinggal" name="alamat_tinggal" value="<?= $panggilan['alamat_tinggal']; ?>">
                        </div>
                        <div class="form-group">
                            <label for="deskripsi">Deskripsi</label>
                            <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5"><?= $panggilan['deskripsi']; ?></textarea>
                        </div>
                        <div class="form-group">
                            <label for="link_foto">Upload Foto</label>
                            <?php if ($panggilan['link_foto']) : ?>
                                <p>Foto Saat Ini: <img src="<?= base_url('asset/img/panggilan/' . $panggilan['link_foto']); ?>" alt="Current Image" width="100"></p>
                            <?php endif; ?>
                        </div>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="link_foto" name="link_foto">
                                <label class="custom-file-label" for="link_foto">Choose file</label>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                        <a href="<?= base_url('d_panggilan'); ?>" class="btn btn-secondary">Kembali</a>
                    </form>
                </div>
            </div>
        </div>
    </div>

</div>
<!-- /.container-fluid -->

<script>
    $('.custom-file-input').on('change', function() {
        let fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').addClass("selected").html(fileName);
    });
</script>