<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-4 text-gray-800"><?= $title; ?></h1>
    <div class="row">
        <div class="col-lg">
            <form action="<?= base_url('d_lingkungan/edit/' . $lingk['id']); ?>" method="post" enctype="multipart/form-data">
                <div class="form-group">
                    <label for="kategori">Kategori</label>
                    <input type="text" class="form-control" id="kategori" value="<?= html_escape($lingk['kategori']); ?>" disabled>
                </div>
                <div class="form-group">
                    <label for="nama_pelindung">Nama Pelindung</label>
                    <input type="text" class="form-control" id="nama_pelindung" value="<?= html_escape($lingk['nama_pelindung']); ?>" disabled>
                </div>
                <div class="form-group">
                    <label for="lokasi">Lokasi</label>
                    <input type="text" class="form-control" id="lokasi" value="<?= html_escape($lingk['lokasi']); ?>" disabled>
                </div>
                <div class="form-group">
                    <label for="wilayah">Wilayah</label>
                    <select class="form-control" id="wilayah" name="wilayah">
                        <option value="">-- Pilih Wilayah --</option>
                        <?php for ($i = 1; $i <= 10; $i++) : ?>
                            <option value="Wilayah <?= $i; ?>" <?= $lingk['wilayah'] == "Wilayah $i" ? 'selected' : ''; ?>>Wilayah <?= $i; ?></option>
                        <?php endfor; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="nama_ketua">Nama Ketua</label>
                    <input type="text" class="form-control" id="nama_ketua" name="nama_ketua" value="<?= html_escape($lingk['nama_ketua']); ?>" required>
                </div>
                <div class="form-group">
                    <label for="id_ketua">ID Ketua</label>
                    <input type="number" class="form-control" id="id_ketua" value="<?= html_escape($lingk['id_ketua']); ?>" required>
                </div>
                <div class="form-group">
                    <label for="gambar_gereja">Gambar Gereja (opsional)</label>
                    <input type="file" class="form-control-file" id="gambar_gereja" name="gambar_gereja">
                    <?php if ($lingk['gambar_gereja']) : ?>
                        <small class="form-text text-muted">Gambar saat ini:</small>
                        <img src="<?= base_url('asset/img/lingkungan/') . $lingk['gambar_gereja']; ?>" class="img-fluid mt-2" style="max-width: 200px;" alt="Preview Gambar Gereja">
                    <?php endif; ?>
                </div>
                <button type="submit" class="btn btn-primary">Simpan</button>
                <a href="<?= base_url('d_lingkungan'); ?>" class="btn btn-secondary">Kembali</a>
            </form>
        </div>
    </div>
</div>