<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-4 text-gray-800"><?= $title; ?></h1>

    <div class="row">
        <div class="col-lg-8">
            <form action="<?= base_url('d_kategorial/edit/' . $kategorial['id']); ?>" method="post" enctype="multipart/form-data">
                <div class="form-group">
                    <label for="judul">Judul <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="judul" name="judul" value="<?= $kategorial['judul']; ?>" required>
                </div>
                <div class="form-group">
                    <label for="keterangan">Keterangan (max 50 karakter) <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="keterangan" name="keterangan" maxlength="50" value="<?= $kategorial['keterangan']; ?>" required>
                </div>
                <div class="form-group">
                    <label for="deskripsi">Deskripsi</label>
                    <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5"><?= $kategorial['deskripsi']; ?></textarea>
                </div>
                <div class="form-group">
                    <label for="logo">Upload Logo</label>
                    <div class="row">
                        <?php if ($kategorial['logo']) : ?>
                            <div class="col-md-4 mb-3">
                                <p>Saat ini:</p>
                                <img src="<?= base_url('asset/img/kategorial/' . $kategorial['logo']); ?>" class="img-fluid" style="max-width: 100px;" alt="Logo Saat Ini">
                            </div>
                        <?php endif; ?>
                        <div class="col-md-8">
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="logo" name="logo">
                                <label class="custom-file-label" for="logo">Choose file</label>
                            </div>
                            <small class="form-text text-muted">Biarkan kosong jika tidak ingin mengubah logo.</small>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                    <a href="<?= base_url('d_kategorial'); ?>" class="btn btn-secondary">Kembali</a>
                </div>
            </form>
        </div>
    </div>

</div>
<!-- /.container-fluid -->

<script>
    $('.custom-file-input').on('change', function() {
        let fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').addClass("selected").html(fileName);
    });
</script>