<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class D_Kumpulan_lagu extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->library('session');
        $this->load->model('Lagu_model', 'lagu');

        if (!$this->session->userdata('email')) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Silakan login terlebih dahulu!</div>');
            redirect('auth');
        }
    }

    public function index() {
        $data['title'] = 'Kumpulan Lagu';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();

        if (!$data['user']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Pengguna tidak ditemukan! Silakan login ulang.</div>');
            redirect('auth');
        }

        $search = $this->input->get('search');
        $status = $this->input->get('status');

        if ($data['user']['role_id'] == 1) {
            $data['lagu'] = $this->lagu->getLagu($search, $status);
        } else {
            $data['lagu'] = $this->lagu->getLaguByUser($data['user']['id'], $search, $status);
        }

        $this->form_validation->set_rules('jenis_lagu', 'Jenis Lagu', 'required');
        $this->form_validation->set_rules('kategori_lagu', 'Kategori Lagu', 'required');
        $this->form_validation->set_rules('judul_lagu', 'Judul Lagu', 'required');
        $this->form_validation->set_rules('pdf', 'File PDF', 'callback_validate_pdf');

        if ($this->form_validation->run() == false && !$this->input->post()) {
            $this->load->view('template/user_header', $data);
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topbar', $data);
            $this->load->view('d_kumpulan_lagu/index', $data);
            $this->load->view('template/user_footer');
        } else {
            $upload_pdf = $_FILES['pdf']['name'];
            if ($upload_pdf) {
                $ext = pathinfo($upload_pdf, PATHINFO_EXTENSION);
                $nama_file = basename($upload_pdf, '.' . $ext);
                $nama_file_baru = $nama_file . '_' . time() . '.' . $ext;

                $config['upload_path'] = './asset/pdf/lagu/';
                $config['allowed_types'] = 'pdf';
                $config['max_size'] = 12048; // 12MB
                $config['file_name'] = $nama_file_baru;
                $config['overwrite'] = TRUE;

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('pdf')) {
                    $new_pdf = $this->upload->data('file_name');
                } else {
                    $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal mengunggah PDF: ' . $this->upload->display_errors() . '</div>');
                    redirect('d_kumpulan_lagu');
                }
            }

            $data_insert = [
                'jenis_lagu' => $this->input->post('jenis_lagu'),
                'kategori_lagu' => $this->input->post('kategori_lagu'),
                'judul_lagu' => $this->input->post('judul_lagu'),
                'deskripsi_lagu' => $this->input->post('deskripsi_lagu'),
                'pdf' => $new_pdf,
                'role' => 0,
            ];

            if ($this->db->insert('lagu_db', $data_insert)) {
                $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Lagu berhasil ditambahkan!</div>');
            } else {
                $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal menyimpan lagu!</div>');
            }
            redirect('d_kumpulan_lagu');
        }
    }

    public function validate_pdf($str) {
        if (empty($_FILES['pdf']['name']) && !$this->input->post('existing_pdf')) {
            $this->form_validation->set_message('validate_pdf', 'File PDF wajib diunggah!');
            return FALSE;
        }
        return TRUE;
    }

    public function publish($id = null) {
        $user = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        if ($user['role_id'] != 1) {
            redirect('d_kumpulan_lagu');
        }

        // Validasi ID
        if (!$id || !is_numeric($id)) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">ID lagu tidak valid!</div>');
            redirect('d_kumpulan_lagu');
        }

        // Periksa apakah lagu dengan ID tersebut ada
        $lagu = $this->db->get_where('lagu_db', ['id' => $id])->row_array();
        if (!$lagu) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Lagu tidak ditemukan!</div>');
            redirect('d_kumpulan_lagu');
        }

        // Update hanya lagu dengan ID yang sesuai
        $this->db->where('id', $id);
        $this->db->set('role', 1);
        $affected_rows = $this->db->update('lagu_db');

        if ($affected_rows) {
            $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Lagu berhasil dipublikasikan!</div>');
        } else {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal mempublikasikan lagu!</div>');
        }
        redirect('d_kumpulan_lagu');
    }

    public function edit($id) {
        $data['title'] = 'Edit Lagu';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['lagu'] = $this->db->get_where('lagu_db', ['id' => $id])->row_array();

        if (!$data['lagu']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Lagu tidak ditemukan!</div>');
            redirect('d_kumpulan_lagu');
        }

        $this->form_validation->set_rules('jenis_lagu', 'Jenis Lagu', 'required');
        $this->form_validation->set_rules('kategori_lagu', 'Kategori Lagu', 'required');
        $this->form_validation->set_rules('judul_lagu', 'Judul Lagu', 'required');

        if ($this->form_validation->run() == false) {
            $this->load->view('template/user_header', $data);
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topbar', $data);
            $this->load->view('d_kumpulan_lagu/edit', $data);
            $this->load->view('template/user_footer');
        } else {
            $upload_pdf = $_FILES['pdf']['name'];
            if ($upload_pdf) {
                $ext = pathinfo($upload_pdf, PATHINFO_EXTENSION);
                $nama_file = basename($upload_pdf, '.' . $ext);
                $nama_file_baru = $nama_file . '_' . time() . '.' . $ext;

                $config['upload_path'] = './asset/pdf/lagu/';
                $config['allowed_types'] = 'pdf';
                $config['max_size'] = 12048;
                $config['file_name'] = $nama_file_baru;
                $config['overwrite'] = TRUE;

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('pdf')) {
                    $old_pdf = $data['lagu']['pdf'];
                    if ($old_pdf && file_exists(FCPATH . 'asset/pdf/lagu/' . $old_pdf)) {
                        unlink(FCPATH . 'asset/pdf/lagu/' . $old_pdf);
                    }
                    $new_pdf = $this->upload->data('file_name');
                } else {
                    $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal mengunggah PDF: ' . $this->upload->display_errors() . '</div>');
                    redirect('d_kumpulan_lagu/edit/' . $id);
                }
            } else {
                $new_pdf = $data['lagu']['pdf'];
            }

            $data_update = [
                'jenis_lagu' => $this->input->post('jenis_lagu'),
                'kategori_lagu' => $this->input->post('kategori_lagu'),
                'judul_lagu' => $this->input->post('judul_lagu'),
                'deskripsi_lagu' => $this->input->post('deskripsi_lagu'),
                'pdf' => $new_pdf,
                'role' => 0
            ];

            $this->db->where('id', $id);
            if ($this->db->update('lagu_db', $data_update)) {
                $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Lagu berhasil diperbarui!</div>');
            } else {
                $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal memperbarui lagu!</div>');
            }
            redirect('d_kumpulan_lagu');
        }
    }
}