
<style>
    
.hero {
    position: relative;
    height: 70vh;
    display: flex;
    justify-content: center;
    align-items: center;
    text-align: center;
    color: #fff;
    padding-top: 60px;
    background-size: cover;
    background-position: center;
    background-attachment: fixed;
}



    /* SK Section */
.sk {
    position: relative; /* Diperlukan untuk overlay ::before */
    background-image: url("<?php echo base_url('asset/website/img/bg7.jpg'); ?>"); /* Ganti dengan gambar yang diinginkan */
    background-size: cover;
    background-position: center;
    background-attachment: fixed; /* Efek parallax */
    color: #f4f1e8; /* Warna teks krem muda untuk kontras */
    padding: 3rem 15px; /* Padding seperti detail artikel */
}

/* Overlay untuk transparansi 70% dengan warna coklat */
.sk::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%; /* Warna coklat  var(--color-primary) dengan transparansi 70% */
    z-index: 1;
}

/* Container untuk konten */
.containerlayanan {
    position: relative;
    z-index: 2; /* Konten di atas overlay */
    max-width: 800px; /* Sama seperti .container3 di detail artikel */
    margin: 0 auto;
    padding: 0 15px;
}

/* Judul utama */
.sk h3 {
    font-size: 32px; /* Sama seperti .detail-artikel-title */
    font-weight: bold;
    text-align: center;
    margin-bottom: 20px; /* Margin lebih besar seperti detail artikel */
    color:  var(--color-primary);
}

.sk h3 span {
    color:  var(--color-primary); /* Krem lebih terang untuk aksen */
}


/* Konten utama */
.sk-content {
    margin: 20px 0; /* Sama seperti .detail-artikel-container */
    text-align: justify; /* Rata kiri-kanan seperti .detail-artikel-content */
    line-height: 1.6; /* Sama seperti .detail-artikel-content */
}

/* Paragraf */
.sk p {
    font-family: "open-sans", sans-serif; /* Perbaiki typo dari copen-sans */
    font-size: 16px; /* Lebih besar untuk keterbacaan */
    margin-bottom: 20px; /* Margin seperti detail artikel */
    color:  var(--color-primary);
}

/* Subjudul */
.sk h2 {
    font-family: "open-sans", sans-serif;
    font-size: 20px; /* Lebih besar untuk hierarki */
    font-weight: bold;
    margin-top: 20px;
    margin-bottom: 10px;
    color:  var(--color-primary);
}

/* Daftar Ordered */
.sk ol {
    font-family: "open-sans", sans-serif;
    font-size: 16px;
    line-height: 1.6;
    padding-left: 20px;
    margin-bottom: 20px;
    color: var(--color-primary);
}

.sk ol li {
    font-family: "open-sans", sans-serif;
}

/* Daftar Unordered */
.sk ul {
    list-style-type: none;
    padding-left: 0;
    margin-bottom: 20px;
}

.sk ul li {
    position: relative;
    padding-left: 1.5rem;
    font-family: "open-sans", sans-serif;
    font-size: 16px;
    line-height: 1.6;
    color: var(--color-primary);
}

.sk ul li::before {
    content: "•";
    position: absolute;
    left: 0;
    font-size: 16px;
    color:  var(--color-primary);
}

/* Tombol */
.tombol0 {
    text-align: center;
    margin-top: 40px; /* Margin lebih besar untuk pemisahan */
}

.tombol1 {
    margin-top: 15px;
}

.btn-sk {
    display: inline-block;
    padding: 10px 20px; /* Sama seperti .btn-back */
    background-color: #7a3814; /* Warna seperti .btn-back */
    color: white;
    text-decoration: none;
    border-radius: 5px; /* Sama seperti .btn-back */
    border: none;
    font-size: 16px;
    cursor: pointer;
    transition: background-color 0.3s ease; /* Sama seperti .btn-back */
}

.tgl {
    display: inline-block;
    padding: 10px 20px; /* Sama seperti .btn-back */
    background-color: #7a3814; /* Warna seperti .btn-back */
    color: white;
    text-decoration: none;
    border-radius: 5px; /* Sama seperti .btn-back */
    border: none;
    font-size: 16px;
    cursor: pointer;
    transition: background-color 0.3s ease; /* Sama seperti .btn-back */
}

.btn-sk:hover {
    background-color: #5e2a0f; /* Warna hover seperti .btn-back */
}

.btn-sk .white-text {
    color: white;
    text-decoration: none;
}

/* Responsivitas */
@media (max-width: 1024px) {
    .sk {
        padding: 2.5rem 10px;
    }
    .containerlayanan {
        max-width: 700px;
    }
    .sk h3 {
        font-size: 28px;
    }
    .sk h2 {
        font-size: 18px;
    }
    .sk p, .sk ul li, .sk ol li {
        font-size: 15px;
    }
}

@media (max-width: 790px) {
    .sk {
        padding: 2rem 10px;
    }
    .containerlayanan {
        max-width: 600px;
    }
    .sk h3 {
        font-size: 24px;
    }
    .sk h2 {
        font-size: 16px;
    }
    .sk p, .sk ul li, .sk ol li {
        font-size: 14px;
    }
    .btn-sk {
        padding: 8px 15px;
        font-size: 14px;
    }
}

@media (max-width: 480px) {
    .sk {
        padding: 1.5rem 10px;
        background-attachment: scroll; /* Fallback untuk mobile */
    }
    .containerlayanan {
        max-width: 100%;
        padding: 0 10px;
    }
    .sk h3 {
        font-size: 20px;
    }
    .sk h2 {
        font-size: 14px;
    }
    
.hero-logo {
    padding-top: 1rem;
	width: 40px;
}

.hero h4 {
    padding-top: 1rem;
	font-size: 10px;
}

.hero-title span {
	font-size: 20px;
}

.hero-title {
	font-size: 12px;
}
.tgl {
    padding: 6px 15px; /* Sama seperti .btn-back */
    text-decoration: none;
    border-radius: 5px; /* Sama seperti .btn-back */
    font-size: 10px;
}

    .sk p, .sk ul li, .sk ol li {
        font-size: 10px;
        line-height: 1.5;
    }
    .btn-sk {
        padding: 6px 12px;
        font-size: 12px;
    }
    .tombol0 {
        margin-top: 30px;
    }
    .tombol1 {
        margin-top: 10px;
    }
    
}
</style>