<section class="hero">
    <div class="hero-content">
        <img
            src="<?= base_url('asset/website/img/'); ?>logo.png"
            alt="Logo Paroki Santa Maria Blitar"
            class="hero-logo"
        />
        <h1 class="hero-title">
            <span>Pengumuman</span><br> 
        </h1>
        <h4>
            Gereja Katolik Paroki Santa Maria Blitar
        </h4>
    </div>
</section>

<section class="announcement-section">
    <div class="announcement-grid">
        <?php if (!empty($pengumuman)): ?>
            <?php foreach ($pengumuman as $item): ?>
                <?php
                // Gabungkan desc1 untuk kartu
                $desc1 = $item['tanggal_kegiatan'] . " | Pukul " . $item['jam_kegiatan'] . " | " . $item['panitia'];
                // Informasi lengkap untuk modal
                $modalInfo = $item['tanggal_kegiatan'] . " | Pukul " . $item['jam_kegiatan'] . " | " . $item['panitia'] . " | " . $item['tempat_kegiatan'];
                ?>
                <div 
                    class="announcement-card"
                    data-image="<?= base_url('asset/img/pengumuman/') . $item['upload_gambar'] ?>"
                    data-title="<?= htmlspecialchars($item['judul']) ?>"
                    data-info="<?= htmlspecialchars($modalInfo) ?>"
                    data-desc="<?= htmlspecialchars($item['deskripsi']) ?>"
                    data-whatsapp="https://wa.me/<?= $item['kontak_cs'] ?>"
                >
                    <img src="<?= base_url('asset/img/pengumuman/') . $item['upload_gambar'] ?>" 
                         alt="<?= htmlspecialchars($item['judul']) ?>" 
                         class="card-image" />
                    <div class="card-content">
                        <h3 class="card-title"><?= htmlspecialchars($item['judul']) ?></h3>
                        <p class="card-description"><?= htmlspecialchars($desc1) ?></p>
                        <button class="read-more-btn">Baca Selengkapnya</button>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <p>Tidak ada pengumuman tersedia saat ini.</p>
        <?php endif; ?>
    </div>
</section>

<!-- Modal Pengumuman -->
<div class="modal" id="announcementModal">
    <div class="modal-content">
        <span class="close-btn" id="closeModalAnnouncement">×</span>
        <img src="" alt="Poster" class="modal-image" id="modalImage" />
        <h3 class="modal-title" id="modalTitle"></h3>
        <p class="modal-info" id="modalInfo"></p>
        <p class="modal-desc" id="modalDesc"></p>
        <a href="#" class="whatsapp-btn" id="modalWhatsapp" target="_blank">Informasi dan Pendaftaran</a>
    </div>
</div>

<style>
.hero {
    background-image: url("<?php echo base_url('asset/website/img/bg4.jpg'); ?>");
    position: relative;
    height: 30rem;
    display: flex;
    justify-content: center;
    align-items: center;
    text-align: center;
    color: #fff;
    padding-top: 60px;
    background-size: cover;
    background-position: center;
}

/* Announcement Section */
.announcement-section {
    padding: 40px 0;
    text-align: center;
    position: relative;
}

.section-title2 {
    font-size: 36px;
    font-weight: normal;
    text-align: center;
    color:  var(--color-primary);
}

.title-kecil2 {
    font-size: 24px;
    font-weight: normal;
    text-align: center;
    color:  var(--color-primary);
}

.section-divider2 {
    width: 30rem;
    height: 1px;
    background:  var(--color-primary);
    border: none;
    margin: 1rem auto 20px;
}

/* Announcement Grid */
.announcement-grid {
    max-width: 1100px;
    margin: 0 auto;
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
    padding: 20px;
}

.announcement-card {
    background: white;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    transition: transform 0.3s ease;
    cursor: pointer;
}

.announcement-card:hover {
    transform: translateY(-5px);
}

.card-image {
    width: 100%;
    height: 200px;
    object-fit: cover;
    border-radius: 8px 8px 0 0;
}

.card-content {
    padding: 15px;
    text-align: left;
}

.card-title {
    font-size: 18px;
    font-weight: normal;
    margin: 0 0 10px;
    color: #333;
}

.card-description {
    font-size: 12px;
    color: #666;
    margin: 0 0 15px;
    line-height: 1.4;
}

.read-more-btn {
    background:  var(--color-primary);
    color: white;
    border: none;
    padding: 8px 12px;
    border-radius: 5px;
    cursor: pointer;
    font-weight: 500;
    font-size: 12px;
    transition: background 0.3s ease, transform 0.3s ease;
    width: 100%;
}

.read-more-btn:hover {
    background: #7a3814;
    transform: scale(1.05);
}

/* Modal Styles */
.modal {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.8);
    z-index: 1000;
    display: flex;
    justify-content: center;
    align-items: center;
}

.modal-content {
    background: white;
    padding: 20px;
    border-radius: 10px;
    max-width: 600px;
    width: 90%;
    max-height: 80vh;
    overflow-y: auto;
    position: relative;
    text-align: center;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
}

.modal-image {
    width: 100%;
    max-height: 400px;
    object-fit: contain;
    border-radius: 10px;
    margin-bottom: 15px;
}

.modal-title {
    font-size: 28px;
    font-weight: 600;
    color: #333;
    margin-bottom: 10px;
    text-align: center;
}

.modal-info {
    font-size: 12px;
    color: #666;
    margin-bottom: 15px;
    line-height: 1.4;
    text-align: center;
}

.modal-desc {
    font-size: 16px;
    color: #333;
    margin-bottom: 20px;
    line-height: 1.5;
    text-align: left;
}

.whatsapp-btn {
    display: inline-block;
    background: #25d366;
    color: white;
    padding: 12px 20px;
    border-radius: 5px;
    text-decoration: none;
    font-size: 14px;
    font-weight: 500;
    transition: background 0.3s ease;
}

.whatsapp-btn:hover {
    background: #1da851;
}

.close-btn {
    position: absolute;
    top: 10px;
    right: 15px;
    font-size: 24px;
    cursor: pointer;
    color: #333;
    font-weight: bold;
}

.close-btn:hover {
    color:  var(--color-primary);
}

/* Responsive Design */
@media (max-width: 790px) {
    .section-title2 {
        font-size: 30px;
    }

    .title-kecil2 {
        font-size: 18px;
    }

    .section-divider2 {
        width: 20rem;
    }

    .announcement-grid {
        grid-template-columns: repeat(2, 1fr);
    }

    .card-image {
        height: 180px;
    }

    .card-title {
        font-size: 16px;
    }

    .card-description {
        font-size: 10px;
    }

    .modal-title {
        font-size: 24px;
    }

    .modal-info {
        font-size: 11px;
    }

    .modal-desc {
        font-size: 14px;
    }

    .modal-image {
        max-height: 300px;
    }

    .modal-content {
        max-height: 85vh;
    }
}

@media (max-width: 480px) {
    .section-title2 {
        font-size: 24px;
    }

    .title-kecil2 {
        font-size: 15px;
    }

    .section-divider2 {
        width: 90%;
        max-width: 400px;
    }

    .announcement-grid {
        grid-template-columns: 1fr;
    }

    .card-image {
        height: 160px;
    }

    .card-title {
        font-size: 14px;
    }

    .card-description {
        font-size: 10px;
    }

    .modal-title {
        font-size: 20px;
    }

    .modal-info {
        font-size: 10px;
    }

    .modal-desc {
        font-size: 12px;
    }

    .modal-image {
        max-height: 250px;
    }

    .modal-content {
        padding: 15px;
        max-height: 90vh;
    }

    .whatsapp-btn {
        padding: 10px 15px;
        font-size: 12px;
    }
}
</style>

<script>
document.addEventListener("DOMContentLoaded", function () {
    // === Login Modal Logic ===
    const userIcon = document.querySelector("#openLoginModal");
    const loginModal = document.getElementById("loginModal");
    const modalChoice = document.getElementById("modalChoice");
    const modalLogin = document.getElementById("modalLogin");
    const closeLoginModal = document.querySelector(".close");
    const loginFormBtn = document.getElementById("loginFormBtn");
    const externalLinkBtn = document.getElementById("externalLinkBtn");
    const loginForm = document.querySelector(".user");
    const navMenu = document.querySelector(".nav-menu");
    const hamburger = document.querySelector(".hamburger");

    // Validasi elemen login modal
    if (loginModal && !userIcon && !modalChoice && !modalLogin && !closeLoginModal && !loginFormBtn && !externalLinkBtn && !loginForm) {
        console.warn("Warning: Login modal exists but other login-related elements are missing.");
    }

    // Toggle Hamburger Menu
    if (hamburger && navMenu) {
        hamburger.addEventListener("click", () => {
            hamburger.classList.toggle("active");
            navMenu.classList.toggle("active");
        });
    }

    // Buka modal login hanya saat ikon login diklik
    if (userIcon && loginModal) {
        userIcon.addEventListener("click", (e) => {
            e.preventDefault();
            loginModal.style.display = "block";
            if (modalChoice) modalChoice.style.display = "flex";
            if (modalLogin) modalLogin.style.display = "none";
            // Tutup navbar jika terbuka
            if (navMenu && navMenu.classList.contains("active")) {
                navMenu.classList.remove("active");
                hamburger.classList.remove("active");
            }
            console.log("Login modal opened via user icon click");
        });
    }

    // Tutup modal login dengan tombol close
    if (closeLoginModal && loginModal) {
        closeLoginModal.addEventListener("click", () => {
            loginModal.style.display = "none";
            console.log("Login modal closed via close button");
        });
    }

    // Tutup modal login saat klik di luar konten
    if (loginModal) {
        loginModal.addEventListener("click", (event) => {
            if (event.target === loginModal) {
                loginModal.style.display = "none";
                console.log("Login modal closed via outside click");
            }
        });
    }

    // Tombol Login dengan Username
    if (loginFormBtn && modalChoice && modalLogin) {
        loginFormBtn.addEventListener("click", () => {
            modalChoice.style.display = "none";
            modalLogin.style.display = "block";
            console.log("Switched to login form");
        });
    }

    // Tombol Login Eksternal
    if (externalLinkBtn) {
        externalLinkBtn.addEventListener("click", () => {
            window.location.href = "https://example.com/login";
            console.log("Redirecting to external login");
        });
    }

    // Handle form submission dengan AJAX
    if (loginForm) {
        loginForm.addEventListener("submit", function (e) {
            e.preventDefault();
            const formData = new FormData(this);

            fetch(this.action, {
                method: "POST",
                body: formData,
                headers: {
                    "X-Requested-With": "XMLHttpRequest",
                },
            })
                .then((response) => {
                    if (!response.ok) throw new Error("Network response was not ok");
                    return response.json();
                })
                .then((data) => {
                    console.log("Response from server:", data);
                    if (data.success) {
                        console.log("Redirecting to:", data.redirect);
                        window.location.href = data.redirect;
                    } else {
                        const errorMessage = document.getElementById("errorMessage");
                        if (errorMessage) {
                            errorMessage.innerHTML = `<div class="alert alert-danger">${
                                data.message || "Login gagal, periksa kembali input Anda."
                            }</div>`;
                        }
                        if (loginModal && modalLogin) {
                            loginModal.style.display = "block";
                            modalLogin.style.display = "block";
                            console.log("Login failed, showing login modal");
                        }
                    }
                })
                .catch((error) => {
                    console.error("Error:", error);
                    const errorMessage = document.getElementById("errorMessage");
                    if (errorMessage) {
                        errorMessage.innerHTML =
                            '<div class="alert alert-danger">Terjadi kesalahan, silakan coba lagi.</div>';
                    }
                    if (loginModal && modalLogin) {
                        loginModal.style.display = "block";
                        modalLogin.style.display = "block";
                        console.log("Error occurred, showing login modal");
                    }
                });
        });
    }

    // Pastikan modal login tidak muncul saat halaman dimuat
    if (loginModal) {
        loginModal.style.display = "none";
    }

    // === Announcement Modal Logic ===
    const announcementModal = document.getElementById("announcementModal");
    const modalImage = document.getElementById("modalImage");
    const modalTitle = document.getElementById("modalTitle");
    const modalInfo = document.getElementById("modalInfo");
    const modalDesc = document.getElementById("modalDesc");
    const modalWhatsapp = document.getElementById("modalWhatsapp");
    const closeModalAnnouncement = document.getElementById("closeModalAnnouncement");
    const announcementCards = document.querySelectorAll(".announcement-card");

    // Validasi elemen modal pengumuman
    if (!announcementModal || !modalImage || !modalTitle || !modalInfo || !modalDesc || !modalWhatsapp || !closeModalAnnouncement) {
        console.error("Error: One or more announcement modal elements are missing.");
        return;
    }

    // Validasi kartu pengumuman
    if (!announcementCards.length) {
        console.warn("Warning: No announcement cards found.");
        return;
    }

    // Fungsi untuk membuka modal pengumuman
    function openAnnouncementModal(card) {
        modalImage.src = card.dataset.image || "";
        modalImage.alt = card.dataset.title || "Poster";
        modalTitle.textContent = card.dataset.title || "No Title";
        modalInfo.textContent = card.dataset.info || "No Info";
        modalDesc.textContent = card.dataset.desc || "No Description";
        modalWhatsapp.href = card.dataset.whatsapp || "#";
        announcementModal.style.display = "flex";
        console.log(`Announcement modal opened for card: ${card.dataset.title}`);
    }

    // Handle klik pada kartu pengumuman
    announcementCards.forEach((card) => {
        card.addEventListener("click", (e) => {
            if (e.target.tagName === "A") {
                return;
            }
            openAnnouncementModal(card);
        });

        const readMoreBtn = card.querySelector(".read-more-btn");
        if (readMoreBtn) {
            readMoreBtn.addEventListener("click", (e) => {
                e.stopPropagation();
                openAnnouncementModal(card);
            });
        }
    });

    // Tutup modal pengumuman dengan tombol close
    if (closeModalAnnouncement && announcementModal) {
        closeModalAnnouncement.addEventListener("click", () => {
            announcementModal.style.display = "none";
            console.log("Announcement modal closed via close button");
        });
    }

    // Tutup modal pengumuman saat klik di luar konten
    if (announcementModal) {
        announcementModal.addEventListener("click", (event) => {
            if (event.target === announcementModal) {
                announcementModal.style.display = "none";
                console.log("Announcement modal closed via outside click");
            }
        });
    }

    // Tutup modal pengumuman dengan tombol Escape
    document.addEventListener("keydown", (event) => {
        if (event.key === "Escape") {
            if (announcementModal && announcementModal.style.display === "flex") {
                announcementModal.style.display = "none";
                console.log("Announcement modal closed via Escape key");
            }
            if (loginModal && loginModal.style.display === "block") {
                loginModal.style.display = "none";
                console.log("Login modal closed via Escape key");
            }
        }
    });

    // Pastikan modal pengumuman tidak muncul saat halaman dimuat
    if (announcementModal) {
        announcementModal.style.display = "none";
    }

    // Sesuaikan tinggi nav menu (opsional)
    function adjustNavMenuHeight() {
        if (navMenu && window.innerWidth <= 790) {
            const navbar = document.querySelector(".navbar");
            if (navbar) {
                const navbarHeight = navbar.offsetHeight;
                const windowHeight = window.innerHeight;
                const maxHeight = windowHeight - navbarHeight - 10;
                navMenu.style.maxHeight = `${maxHeight}px`;
            }
        } else if (navMenu) {
            navMenu.style.maxHeight = "";
        }
    }

    window.addEventListener("load", adjustNavMenuHeight);
    window.addEventListener("resize", adjustNavMenuHeight);
});
</script>