<section class="hero">
    <div class="hero-content">
        <img
            src="<?= base_url('asset/website/img/'); ?>logo.png"
            alt="Logo Paroki Santa Maria Blitar"
            class="hero-logo"
        />
        <h1 class="hero-title">
            <span>DPP & BGKP</span><br> 
        </h1>
        <h4>
            Gereja Katolik Paroki Santa Maria Blitar
        </h4>
    </div>
</section>


<!-- Organization Section -->
<!-- Organization Section -->
    <section class="organization-section">
        <div class="organization-container">
            <div class="organization-header">
                <h2 class="organization-title">Dewan Gereja Katolik Paroki</h2>
                <h3 class="organization-subtitle">Santa Maria Blitar</h3>
            </div>
            <div class="organization-grid">
                <!-- Organisasi 1 -->
                <div class="organization-item">
                    <div class="organization-text">
                        <h4 class="organization-name">Dewan Paroki</h4>
                        <p class="organization-description">Mengkoordinasikan seluruh kegiatan paroki dan membuat keputusan strategis.</p>
                    </div>
                    <div class="organization-logo">
                        <img src="<?= base_url('asset/website/img/'); ?>logo.png" alt="Logo Dewan Paroki">
                    </div>
                </div>
                <!-- Organisasi 2 -->
                <div class="organization-item">
                    <div class="organization-text">
                        <h4 class="organization-name">Komisi Liturgi</h4>
                        <p class="organization-description">Merencanakan dan mengelola kegiatan ibadah dan liturgi paroki.</p>
                    </div>
                    <div class="organization-logo">
                        <img src="<?= base_url('asset/website/img/'); ?>logo.png" alt="Logo Komisi Liturgi">
                    </div>
                </div>
                <!-- Organisasi 3 -->
                <div class="organization-item">
                    <div class="organization-text">
                        <h4 class="organization-name">Komisi Kateketik</h4>
                        <p class="organization-description">Menyelenggarakan pendidikan agama dan katekese untuk umat.</p>
                    </div>
                    <div class="organization-logo">
                        <img src="<?= base_url('asset/website/img/'); ?>logo.png" alt="Logo Komisi Kateketik">
                    </div>
                </div>
                <!-- Organisasi 4 -->
                <div class="organization-item">
                    <div class="organization-text">
                        <h4 class="organization-name">Komisi Kerasulan Keluarga</h4>
                        <p class="organization-description">Mendampingi keluarga dalam pembinaan iman dan kehidupan kristiani.</p>
                    </div>
                    <div class="organization-logo">
                        <img src="<?= base_url('asset/website/img/'); ?>logo.png" alt="Logo Komisi Kerasulan Keluarga">
                    </div>
                </div>
                <!-- Organisasi 5 -->
                <div class="organization-item">
                    <div class="organization-text">
                        <h4 class="organization-name">Komisi Pemuda</h4>
                        <p class="organization-description">Menggerakkan pemuda untuk aktif dalam kegiatan rohani dan sosial.</p>
                    </div>
                    <div class="organization-logo">
                        <img src="<?= base_url('asset/website/img/'); ?>logo.png" alt="Logo Komisi Pemuda">
                    </div>
                </div>
                <!-- Organisasi 6 -->
                <div class="organization-item">
                    <div class="organization-text">
                        <h4 class="organization-name">Komisi Sosial</h4>
                        <p class="organization-description">Menangani kegiatan sosial dan kemanusiaan untuk masyarakat.</p>
                    </div>
                    <div class="organization-logo">
                        <img src="<?= base_url('asset/website/img/'); ?>logo.png" alt="Logo Komisi Sosial">
                    </div>
                </div>
                <!-- Organisasi 7 -->
                <div class="organization-item">
                    <div class="organization-text">
                        <h4 class="organization-name">Komisi Pendidikan</h4>
                        <p class="organization-description">Mengembangkan program pendidikan berbasis iman Katolik.</p>
                    </div>
                    <div class="organization-logo">
                        <img src="<?= base_url('asset/website/img/'); ?>logo.png" alt="Logo Komisi Pendidikan">
                    </div>
                </div>
                <!-- Organisasi 8 -->
                <div class="organization-item">
                    <div class="organization-text">
                        <h4 class="organization-name">Komisi Hubungan Antaragama</h4>
                        <p class="organization-description">Membangun dialog dan kerjasama dengan komunitas agama lain.</p>
                    </div>
                    <div class="organization-logo">
                        <img src="<?= base_url('asset/website/img/'); ?>logo.png" alt="Logo Komisi Hubungan Antaragama">
                    </div>
                </div>
                <!-- Organisasi 9 -->
                <div class="organization-item">
                    <div class="organization-text">
                        <h4 class="organization-name">Komisi Kesehatan</h4>
                        <p class="organization-description">Menyediakan layanan kesehatan dan edukasi bagi umat.</p>
                    </div>
                    <div class="organization-logo">
                        <img src="<?= base_url('asset/website/img/'); ?>logo.png" alt="Logo Komisi Kesehatan">
                    </div>
                </div>
                <!-- Organisasi 10 -->
                <div class="organization-item">
                    <div class="organization-text">
                        <h4 class="organization-name">Komisi Keuangan</h4>
                        <p class="organization-description">Mengelola keuangan paroki dengan transparansi dan akuntabilitas.</p>
                    </div>
                    <div class="organization-logo">
                        <img src="<?= base_url('asset/website/img/'); ?>logo.png" alt="Logo Komisi Keuangan">
                    </div>
                </div>
            </div>
        </div>
    </section>

    <style>
        /* Hero Section Styles */
        .hero {
            background-image: url("<?= base_url('asset/website/img/bg4.jpg'); ?>");
            position: relative;
            height: 30rem;
            display: flex;
            justify-content: center;
            align-items: center;
            text-align: center;
            color: #fff;
            padding-top: 60px;
            background-size: cover;
            background-position: center;
        }

/* Organization Section Styles */
.organization-section {
    padding: 3rem 1rem;
    background: linear-gradient(180deg, rgb(255, 248, 244) 0%, rgb(236, 213, 200) 100%);
}

.organization-container {
    max-width: 1280px;
    margin: 0 auto;
    display: flex;
    flex-direction: column;
    align-items: center;
}

.organization-header {
    text-align: center;
    margin-bottom: 2.5rem;
}

.organization-title {
    font-size: 2.5rem;
    font-weight: 700;
    color:  var(--color-primary);
    margin-bottom: 0.75rem;
    letter-spacing: 0.025em;
}

.organization-subtitle {
    font-size: 1.25rem;
    color: rgb(190, 132, 98);
    font-weight: 400;
}

.organization-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1.5rem;
    justify-content: center;
    max-width: 1280px;
    width: 100%;
    box-sizing: border-box;
}

.organization-item {
    display: flex;
    align-items: center;
    background-color: #ffffff;
    border-radius: 16px;
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
    padding: 1.5rem;
    margin: 2px;
    border: 1px solid #e5e7eb;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.organization-item:hover {
    transform: translateY(-6px);
    box-shadow: 0 10px 24px rgba(0, 0, 0, 0.12);
    border-color:  var(--color-primary);
}

.organization-text {
    flex: 1;
    text-align: left;
    padding-right: 1rem;
}

.organization-name {
    font-size: 1.25rem;
    font-weight: 600;
    color:  var(--color-primary);
    margin-bottom: 0.5rem;
    text-transform: uppercase;
}

.organization-description {
    font-size: 0.875rem;
    color: #1f2937;
    line-height: 1.4;
}

.organization-logo {
    width: 80px;
    height: 80px;
    flex-shrink: 0;
}

.organization-logo img {
    width: 100%;
    height: 100%;
    object-fit: contain;
    border-radius: 8px;
    border: 2px solid #dbeafe;
}

/* Responsive Design */
@media (max-width: 1024px) {
    .organization-grid {
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    }

    .organization-item {
        padding: 1.25rem;
    }

    .organization-title {
        font-size: 2.25rem;
    }

    .organization-subtitle {
        font-size: 1.125rem;
    }

    .organization-name {
        font-size: 1.125rem;
    }

    .organization-description {
        font-size: 0.8125rem;
    }

    .organization-logo {
        width: 70px;
        height: 70px;
    }
}

@media (max-width: 790px) {
    .organization-grid {
        grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
    }

    .organization-item {
        flex-direction: column;
        align-items: flex-start;
        padding: 1rem;
    }

    .organization-text {
        padding-right: 0;
        margin-bottom: 0.75rem;
    }

    .organization-logo {
        width: 60px;
        height: 60px;
        align-self: center;
    }

    .organization-name {
        font-size: 1rem;
    }

    .organization-description {
        font-size: 0.75rem;
    }
}

@media (max-width: 480px) {
    .organization-section {
        padding: 2rem 0.75rem;
    }

    .organization-grid {
        grid-template-columns: 1fr;
        gap: 1.25rem;
    }

    .organization-item {
        padding: 0.75rem;
        margin: 2px;
    }

    .organization-title {
        font-size: 2rem;
    }

    .organization-subtitle {
        font-size: 1rem;
    }

    .organization-name {
        font-size: 0.875rem;
    }

    .organization-description {
        font-size: 0.6875rem;
    }

    .organization-logo {
        width: 50px;
        height: 50px;
    }
}
    </style>