<section class="hero">
    <div class="hero-content">
        <img
            src="<?= base_url('asset/website/img/'); ?>logo.png"
            alt="Logo Paroki Santa Maria Blitar"
            class="hero-logo"
        />
        <h1 class="hero-title">
            <span>DPP & BGKP</span><br> 
        </h1>
        <h4>
            Gereja Katolik Paroki Santa Maria Blitar
        </h4>
    </div>
</section>

<section class="leadership-section">
        <div class="leadership-container">
            <div class="leadership-header">
                <h2 class="leadership-title">Romo Paroki</h2>
                <h3 class="leadership-subtitle">Santa Maria Blitar</h3>
            </div>
            <div class="leadership-grid">
                <!-- Item 1 -->
                <div class="leadership-item">
                    <div class="leadership-position">Romo Kepala</div>
                    <div class="photo-container">
                        <img src="<?= base_url('asset/website/img/romo/'); ?>v.png" alt="Pemimpin">
                    </div>
                    <div class="leadership-name">Rm. Paulus Eko Nurbandrio, CM</div>
                    <div class="leadership-date">27 September 2020</div>
                </div>
                <!-- Item 2 -->
                <div class="leadership-item">
                    <div class="leadership-position">Romo Rekan</div>
                    <div class="photo-container">
                        <img src="<?= base_url('asset/website/img/romo/'); ?>w.png" alt="Pemimpin">
                    </div>
                    <div class="leadership-name">Rm. Stanislaus Beda Eylanor, CM</div>
                    <div class="leadership-date">02 November 2022</div>
                </div>
                <!-- Item 3 -->
                <div class="leadership-item">
                    <div class="leadership-position">Romo Rekan</div>
                    <div class="photo-container">
                        <img src="<?= base_url('asset/website/img/romo/'); ?>p.png" alt="Pemimpin">
                    </div>
                    <div class="leadership-name">Rm. Fransiskus Xaverius Wartadi, CM</div>
                    <div class="leadership-date">2009</div>
                </div>
            </div>
        </div>
    </section>

<!-- Organization Section -->
<section class="organization-section">
    <div class="organization-container">
        <div class="organization-header">
            <h2 class="organization-title">Badan Gereja Katolik Paroki</h2>
            <h3 class="organization-subtitle">Santa Maria Blitar</h3>
        </div>
        <div class="organization-grid">
            <!-- Item 1 -->
            <div class="organization-item">
                <div class="organization-role">Sekretaris 1</div>
                <div class="organization-description">Mengelola administrasi dan dokumentasi kegiatan paroki.</div>
                <div class="organization-lead">Mercelina Windy Linggar Yanti</div>
            </div>
            <!-- Item 2 -->
            <div class="organization-item">
                <div class="organization-role">Sekretaris 2</div>
                <div class="organization-description">Mengelola administrasi dan dokumentasi kegiatan paroki.</div>
                <div class="organization-lead">Stevanus Surya Osada </div>
            </div>
           
        </div><br><br><div class="organization-grid">
            <!-- Item 3 -->
            <div class="organization-item">
                <div class="organization-role">Bendahara 1</div>
                <div class="organization-description"> Mengatur keuangan paroki, termasuk pencatatan pemasukan dan pengeluaran.</div>
                <div class="organization-lead">Kristoforus Raymud Roni Judodihardjo</div>
            </div>
            <!-- Item 4 -->
            <div class="organization-item">
                <div class="organization-role">Bendahara 2</div>
                <div class="organization-description"> Mengatur keuangan paroki, termasuk pencatatan pemasukan dan pengeluaran.</div>
                <div class="organization-lead">Wenseslaus Hanny Sugianto</div>
            </div>
            <!-- Item 5 -->
            <div class="organization-item">
                <div class="organization-role">Bendahara 3</div>
                <div class="organization-description"> Mengatur keuangan paroki, termasuk pencatatan pemasukan dan pengeluaran.</div>
                <div class="organization-lead">Anastasya Leony Widyawati</div>
            </div>
        </div><br><br><div class="organization-grid">
            <!-- Item 5 -->
            <div class="organization-item">
                <div class="organization-role">Anggota 1</div>
                <div class="organization-description">Membantu pelaksanaan program kerja pastoral sesuai bidang yang ditugaskan.</div>
                <div class="organization-lead">Felista Mayviana Gunawan</div>
            </div>
            <!-- Item 5 -->
            <div class="organization-item">
                <div class="organization-role">Anggota 2</div>
                <div class="organization-description">Membantu pelaksanaan program kerja pastoral sesuai bidang yang ditugaskan.</div>
                <div class="organization-lead">Vincensius Apaulo Septa Bianto</div>
            </div>
            <!-- Item 5 -->
            <div class="organization-item">
                <div class="organization-role">Anggota 3</div>
                <div class="organization-description">Membantu pelaksanaan program kerja pastoral sesuai bidang yang ditugaskan.</div>
                <div class="organization-lead">Felicitas Lindawati</div>
            </div>
            
        </div>
        <!-- Item 5 -->
        <br><div class="organization-grid">
        
            <!-- Item 5 -->
            <div class="organization-item">
                <div class="organization-role">Anggota 4</div>
                <div class="organization-description">Membantu pelaksanaan program kerja pastoral sesuai bidang yang ditugaskan.</div>
                <div class="organization-lead">Antonius Priyo Edi Cahyo</div>
            </div>
            <!-- Item 5 -->
            <div class="organization-item">
                <div class="organization-role">Anggota 5</div>
                <div class="organization-description">Membantu pelaksanaan program kerja pastoral sesuai bidang yang ditugaskan.</div>
                <div class="organization-lead">Maria Patricia Tjandra Kristiani Fernita</div>
            </div>
            <!-- Item 5 -->
            <div class="organization-item">
                <div class="organization-role">Anggota 6</div>
                <div class="organization-description">Membantu pelaksanaan program kerja pastoral sesuai bidang yang ditugaskan.</div>
                <div class="organization-lead">Liuni Sulistiawati</div>
            </div>
        </div>
    </div>
    
</section>


<!-- Organization Section -->
<section class="organization-section">
    <div class="organization-container">
        <div class="organization-header">
            <h2 class="organization-title">Dewan Pastoral Paroki</h2>
            <h3 class="organization-subtitle">Santa Maria Blitar</h3>
        </div>
        <div class="organization-grid">
            <!-- Item 1 -->
            <div class="organization-item">
                <div class="organization-role">Ketua Paroki</div>
                <div class="organization-description">Memimpin dan mengkoordinasikan seluruh kegiatan paroki.</div>
                <div class="organization-lead">Pdt. Anna Martinez</div>
            </div>
            <!-- Item 2 -->
            <div class="organization-item">
                <div class="organization-role">Wakil Ketua</div>
                <div class="organization-description">Mendukung ketua dalam pengambilan keputusan dan operasional.</div>
                <div class="organization-lead">Pdt. Robert Taylor</div>
            </div>
            <!-- Item 3 -->
            <div class="organization-item">
                <div class="organization-role">Sekretaris</div>
                <div class="organization-description">Mengurus administrasi dan dokumentasi paroki.</div>
                <div class="organization-lead">Pdt. Lisa Davis</div>
            </div>
            <!-- Item 4 -->
            <div class="organization-item">
                <div class="organization-role">Bendahara</div>
                <div class="organization-description">Mengelola keuangan dan anggaran paroki.</div>
                <div class="organization-lead">Bpk. John Doe</div>
            </div>
            <!-- Item 5 -->
            <div class="organization-item">
                <div class="organization-role">Komisi Liturgi</div>
                <div class="organization-description">Merencanakan dan mengelola kegiatan liturgi.</div>
                <div class="organization-lead">Ibu Maria Smith</div>
            </div>
        </div>
    </div>
</section>




    <style>
        /* Hero Section Styles */
        .hero {
            background-image: url("<?= base_url('asset/website/img/bg4.jpg'); ?>");
            position: relative;
            height: 30rem;
            display: flex;
            justify-content: center;
            align-items: center;
            text-align: center;
            color: #fff;
            padding-top: 60px;
            background-size: cover;
            background-position: center;
        }

      /* Leadership Section Styles */
.leadership-section {
    padding: 3rem 1rem;
    background: linear-gradient(180deg,rgb(255, 248, 244) 0%,rgb(236, 215, 203) 100%);
}

.leadership-container {
    max-width: 1280px;
    margin: 0 auto;
    display: flex;
    flex-direction: column;
    align-items: center;
}

.leadership-header {
    text-align: center;
    margin-bottom: 2.5rem;
}

.leadership-title {
    font-size: 2.5rem;
    font-weight: 700;
    color:  var(--color-primary);
    margin-bottom: 0.75rem;
    letter-spacing: 0.025em;
}

.leadership-subtitle {
    font-size: 1.25rem;
    color:rgb(223, 151, 109);
    font-weight: 400;
}

.leadership-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
    justify-content: center;
    gap: 1.5rem;
    max-width: 1280px;
}

.leadership-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    text-align: center;
    background-color: #ffffff;
    border-radius: 16px;
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
    padding: 1.75rem;
    margin: 2px;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border: 1px solid #e5e7eb;
}

.leadership-item:hover {
    transform: translateY(-6px);
    box-shadow: 0 10px 24px rgba(0, 0, 0, 0.12);
    border-color: var(--color-primary);
}

.leadership-position {
    font-size: 18px;
    font-weight: 600;
    color: var(--color-primary);
    text-transform: uppercase;
    margin-bottom: 0.5rem;
}

.photo-container {
    position: relative;
    width: 200px;
    padding-top: 240px; /* Rasio 3:4 (240px tinggi / 180px lebar = 133.33%) */
    margin: 0.5rem;
    margin-bottom: 1rem;
}

.photo-container img {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    object-fit: cover;
    border-radius: 10px;
    border: 3px solid #dbeafe;
}

.leadership-name {
    font-size: 14px;
    font-weight: 700;
    color:  var(--color-primary);
    margin-bottom: 0.5rem;
}

.leadership-date {
    font-size: 12px;
    font-weight: 400;
    color: #6b7280;
}

/* Responsive Design */
@media (max-width: 1024px) {
    .leadership-grid {
        grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    }

    .photo-container {
        width: 160px;
        padding-top: 213.33px; /* Rasio 3:4 */
        margin: 2px;
    }

    .leadership-item {
        padding: 1.5rem;
        margin: 2px;
    }

    .leadership-title {
        font-size: 2.25rem;
    }

    .leadership-subtitle {
        font-size: 1.125rem;
    }
}

@media (max-width: 790px) {
    .leadership-grid {
        grid-template-columns: repeat(2, minmax(200px, 1fr));
        grid-template-rows: auto auto;
        justify-items: center;
    }

    .leadership-grid > .leadership-item:nth-child(3) {
        grid-column: 1 / -1;
        justify-self: center;
    }

    .photo-container {
        width: 140px;
        padding-top: 186.67px; /* Rasio 3:4 */
        margin: 2px;
    }

    .leadership-item {
        padding: 1.25rem;
        margin: 2px;
    }

    .leadership-position {
        font-size: 22px;
    }

    .leadership-name {
        font-size: 11px;
    }

    .leadership-date {
        font-size: 9px;
    }
}

@media (max-width: 480px) {
    .leadership-section {
        padding: 2rem 0.75rem;
    }

    .leadership-grid {
        grid-template-columns: 1fr;
        gap: 1.25rem;
    }

    .leadership-item {
        padding: 1rem;
        margin: 2px;
    }

    .photo-container {
        width: 120px;
        padding-top: 160px; /* Rasio 3:4 */
        margin: 2px;
    }

    .leadership-position {
        font-size: 20px;
    }

    .leadership-name {
        font-size: 11px;
    }

    .leadership-date {
        font-size: 9px;
    }

    .leadership-title {
        font-size: 2rem;
    }

    .leadership-subtitle {
        font-size: 1rem;
    }
}

/*--------------------------- Organization Section Styles */
.organization-section {
    padding: 3rem 1rem;
    background: linear-gradient(180deg,rgb(255, 248, 244) 0%,rgb(236, 213, 200) 100%);
}

.organization-container {
    max-width: 1280px;
    margin: 0 auto;
    display: flex;
    flex-direction: column;
    align-items: center;
}

.organization-header {
    text-align: center;
    margin-bottom: 2.5rem;
}

.organization-title {
    font-size: 2.5rem;
    font-weight: 700;
    color:  var(--color-primary);
    margin-bottom: 0.75rem;
    letter-spacing: 0.025em;
}

.organization-subtitle {
    font-size: 1.25rem;
    color:rgb(190, 132, 98);
    font-weight: 400;
}

.organization-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 1.5rem;
    justify-content: center;
    max-width: 1280px;
    width: 100%;
    box-sizing: border-box;
}

.organization-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    text-align: center;
    background-color: #ffffff;
    border-radius: 16px;
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
    padding: 1.75rem;
    margin: 2px;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border: 1px solid #e5e7eb;
    position: relative;
}

.organization-item:hover {
    transform: translateY(-6px);
    box-shadow: 0 10px 24px rgba(0, 0, 0, 0.12);
    border-color: var(--color-primary);
}

.organization-role {
    font-size: 1.5rem;
    font-weight: 600;
    color:  var(--color-primary);
    margin-bottom: 0.75rem;
    text-transform: uppercase;
}

.organization-description {
    font-size: 1rem;
    color: var(--color-primary);
    margin-bottom: 0.5rem;
}

.organization-lead {
    font-size: 0.875rem;
    color: #6b7280;
    font-style: italic;
}

/* Connector Lines (for hierarchy visualization) */
.organization-item:not(:last-child)::after {
    content: '';
    position: absolute;
    bottom: -1rem;
    left: 50%;
    width: 2px;
    height: 1rem;
    background-color:  var(--color-primary);
    display: none;
}

.organization-grid:has(.organization-item:nth-child(2)) > .organization-item:nth-child(1)::after {
    display: block;
}

/* Responsive Design */
@media (max-width: 1024px) {
    .organization-grid {
        grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
    }

    .organization-title {
        font-size: 2.25rem;
    }

    .organization-subtitle {
        font-size: 1.125rem;
    }

    .organization-item {
        padding: 1.5rem;
    }

    .organization-role {
        font-size: 1.375rem;
    }

    .organization-description {
        font-size: 0.9375rem;
    }

    .organization-lead {
        font-size: 0.8125rem;
    }
}

@media (max-width: 790px) {
    .organization-grid {
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    }

    .organization-item {
        padding: 1.25rem;
    }

    .organization-role {
        font-size: 1.25rem;
    }

    .organization-item:not(:last-child)::after {
        display: none;
    }
}

@media (max-width: 480px) {
    .organization-section {
        padding: 2rem 0.75rem;
    }

    .organization-grid {
        grid-template-columns: 1fr;
        gap: 1.25rem;
    }

    .organization-item {
        padding: 1rem;
        margin: 2px;
    }

    .organization-title {
        font-size: 2rem;
    }

    .organization-subtitle {
        font-size: 1rem;
    }

    .organization-role {
        font-size: 1.125rem;
    }

    .organization-description {
        font-size: 0.875rem;
    }

    .organization-lead {
        font-size: 0.75rem;
    }
}
    
    </style>