
    <!-- Section Pertama -->
    <section class="hero">
      <div class="hero-content">
        <img
          src="<?= base_url('asset/website/img/'); ?>logo.png"
          alt="Logo Paroki Santa Maria Blitar"
          class="hero-logo"
        />
        <h1 class="hero-title">
          Gereja Katolik <br />
          <span>Santa Maria Blitar</span>
        </h1>
        <p class="hero-quote">
          "Aku adalah jalan, kebenaran, dan hidup." <br />- Yohanes 14:6
        </p>
      </div>
    </section>

    <!-- Sesi Baru: Misa Mingguan -->
    <!-- Jadwal Misa Section -->
    <section class="jadwal-misa py-5">
      <div class="container text-center">
        <h2 class="section-title">Jadwal Misa</h2>
        <p class="title-kecil">Paroki Santa Maria Blitar</p>
        <hr class="section-divider" />
        <div class="schedule-wrapper">
          <!-- Misa Mingguan (Kiri) -->
          <div class="schedule-column">
            <div class="content-box">
              <h3 class="section-subtitle">Misa Mingguan</h3>
            </div>
            <div class="schedule-item">
              <span class="schedule-part">Misa Sabtu Sore</span>
              <span class="schedule-divider">|</span>
              <span class="schedule-part2">Pukul 17.30 WIB</span>
            </div>
            <div class="schedule-item">
              <span class="schedule-part">Misa Minggu Pagi</span>
              <span class="schedule-divider">|</span>
              <span class="schedule-part2">Pukul 07.00 WIB</span>
            </div>
            <div class="schedule-item">
              <span class="schedule-part">Misa Minggu Sore</span>
              <span class="schedule-divider">|</span>
              <span class="schedule-part2">Pukul 17.00 WIB</span>
            </div>
          </div>
          <!-- Misa Harian (Kanan) -->
          <div class="schedule-column">
            <div class="content-box">
              <h3 class="section-subtitle">Misa Harian</h3>
            </div>
            <div class="schedule-item">
              <span class="schedule-part">Setiap Senin-Kamis</span>
              <span class="schedule-divider">|</span>
              <span class="schedule-part2">Pukul 05.30 WIB</span>
            </div>
            <div class="schedule-item">
              <span class="schedule-part">Setiap Jumat</span>
              <span class="schedule-divider">|</span>
              <span class="schedule-part2">Pukul 17.30 WIB</span>
            </div>
          </div>
        </div>
      </div>
    </section>

    <section class="announcement-section">
    <h2 class="section-title2">Pengumuman</h2>
    <p class="title-kecil2">Paroki Santa Maria Blitar</p>
    <hr class="section-divider2" />
    <div class="carousel-wrapper">
        <button class="nav-btn prev-btn">&lt;</button>
        <div class="carousel-container">
            <?php if (!empty($pengumuman)): ?>
                <?php foreach ($pengumuman as $item): ?>
                    <?php
                    // Gabungkan desc1
                    $desc1 = $item['tanggal_kegiatan'] . " | Pukul " . $item['jam_kegiatan'] . " | " . $item['panitia'];
                    // Deskripsi lengkap untuk modal
                    $modalInfo = $item['tanggal_kegiatan'] . " | Pukul " . $item['jam_kegiatan'] . " | " . $item['panitia'] . " | " . $item['tempat_kegiatan'];
                    // Batasi desc2 menjadi 100 karakter untuk kartu
                    $desc2 = substr($item['deskripsi'], 0, 100) . (strlen($item['deskripsi']) > 100 ? '...' : '');
                    ?>
                    <div 
                        class="announcement-card"
                        data-image="<?= base_url('asset/img/pengumuman/') . $item['upload_gambar'] ?>"
                        data-title="<?= htmlspecialchars($item['judul']) ?>"
                        data-info="<?= htmlspecialchars($modalInfo) ?>"
                        data-desc="<?= htmlspecialchars($item['deskripsi']) ?>"
                        data-whatsapp="https://wa.me/<?= $item['kontak_cs'] ?>"
                    >
                        <img src="<?= base_url('asset/img/pengumuman/') . $item['upload_gambar'] ?>" 
                             alt="<?= htmlspecialchars($item['judul']) ?>" 
                             class="card-image" />
                        <div class="card-content">
                            <h3 class="card-title"><?= htmlspecialchars($item['judul']) ?></h3>
                            <p class="card-description"><?= htmlspecialchars($desc1) ?></p>
                            <button class="read-more-btn">Baca Selengkapnya</button>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p>Tidak ada pengumuman tersedia saat ini.</p>
            <?php endif; ?>
        </div>
        <button class="nav-btn next-btn">&gt;</button>
    </div>
</section>

<section class="artikel py-5">
    <a href="<?= base_url('web/artikel') ?>" class="section-title-link">
        <h2 class="section-title2">Artikel</h2>
    </a>
    <a href="<?= base_url('web/artikel') ?>" class="title-kecil-link">
        <p class="title-kecil2">Paroki Santa Maria Blitar</p>
    </a>
    <hr class="section-divider2" />

    <!-- Form Pencarian -->
    <div class="container search-container">
        <form action="<?= base_url('web/artikel') ?>" method="get">
            <div class="input-group">
                <input type="text" name="search" class="form-control" placeholder="Cari judul, kategori, atau isi..." 
                       value="<?= htmlspecialchars($search ?? '') ?>">
                <div class="input-group-append">
                    <button type="submit" class="btn btn-search">Cari</button>
                </div>
            </div>
        </form>
    </div>

    <div class="container">
        <div class="artikel-container">
            <?php if (!empty($artikel)): ?>
                <?php foreach ($artikel as $item): ?>
                    <div class="artikel-item" onclick="window.location.href='<?= base_url('web/detail_artikel/') . $item['id'] ?>'">
                        <div class="artikel-image">
                            <img src="<?= base_url('asset/img/artikel/') . $item['linkg1'] ?>" 
                                 alt="<?= htmlspecialchars($item['judul']) ?>" />
                        </div>
                        <div class="artikel-content">
                            <h3 class="artikel-title"><?= htmlspecialchars($item['judul']) ?></h3>
                            <p class="artikel-date">Diperbarui: <?= date('d F Y', strtotime($item['tanggal'])) ?></p>
                            <p class="artikel-excerpt">
                                <?= substr(strip_tags($item['isi']), 0, 100) . (strlen(strip_tags($item['isi'])) > 100 ? '...' : '') ?>
                            </p>
                            <a href="<?= base_url('web/detail_artikel/') . $item['id'] ?>" class="artikel-link">Baca Selengkapnya >></a>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p>Tidak ada artikel ditemukan.</p>
            <?php endif; ?>
        </div>

        <!-- Pagination -->
        <?php if (isset($pagination)): ?>
            <div class="pagination">
                <?= $pagination ?>
            </div>
        <?php endif; ?>
    </div>
</section>

    <!-- Sesi Baru: Tentang Kami -->
    <section class="tentang-kami py-5">
      <div class="container">
        <h2 class="section-title">Tentang Kami</h2>
        <div class="tentang-kami-wrapper">
          <!-- Informasi Kiri -->
          <div class="tentang-kami-info">
            <h3 class="info-title">Paroki Santa Maria Blitar</h3>
            <p class="info-text">
              <strong>Alamat:</strong> Jl. Kelud No. 12, Blitar, Jawa Timur
              66111, Indonesia
            </p>
            <p class="info-text"><strong>Telepon:</strong> (0342) 801234</p>
            <p class="info-text">
              <strong>Email:</strong> info@parokisantamaria.org
            </p>
            <p class="info-text">
              <strong>Jam Operasional:</strong> Senin - Jumat, 08:00 - 16:00 WIB
            </p>
          </div>
          <!-- Gambar dan Maps Kanan -->
          <div class="tentang-kami-media">
            <div class="paroki-map">
              <iframe
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3951.773258003773!2d112.20024997498747!3d-7.998614592010672!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x2e78fbede592b5b7%3A0xbecd33c0a8fded32!2sGereja%20Santa%20Maria%20Blitar!5e0!3m2!1sid!2sid!4v1698765432100!5m2!1sid!2sid"
                width="100%"
                height="100%"
                style="border: 0"
                allowfullscreen=""
                loading="lazy"
              ></iframe>
            </div>
          </div>
        </div>
      </div>
    </section>



    <!-- Modal -->
    <div class="modal" id="announcementModal">
    <div class="modal-content">
        <span class="close-btn" id="closeModalAnnouncement">×</span>
        <img src="" alt="Poster" class="modal-image" id="modalImage" />
        <h3 class="modal-title" id="modalTitle"></h3>
        <p class="modal-info" id="modalInfo"></p>
        <p class="modal-desc" id="modalDesc"></p>
        <a href="#" class="whatsapp-btn" id="modalWhatsapp" target="_blank">Informasi dan Pendaftaran</a>
    </div>
</div>
  
    <style>
.hero {
    position: relative;
    height: 100vh;
    display: flex;
    justify-content: center;
    align-items: center;
    text-align: center;
    color: #fff;
    padding-top: 60px;
    background-image: url("<?php echo base_url('asset/website/img/bg4.jpg'); ?>"); /* PHP di dalam <style> */
    background-size: cover;
    background-position: center;
    background-attachment: fixed;
}

.jadwal-misa {
	position: relative; /* Diperlukan untuk overlay ::before */
	background-image: url("<?php echo base_url('asset/website/img/bg5.jpg'); ?>"); /* Path dengan base_url */
	background-size: cover;
	background-position: center;
	background-attachment: fixed; /* Background tetap saat scroll */
	color: #f4f1e8; /* Warna teks krem muda untuk kontras */
	padding: 60px 0;
	text-align: center;
}
</style>