<!DOCTYPE html>
<html lang="id">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Paroki Santa Maria Blitar</title>
    <link rel="stylesheet" href="<?= base_url('asset/website/css/'); ?>web_style.css" />
    <link
      rel="stylesheet"
      href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css"
      integrity="sha512-Fo3rlrZj/k7ujTnHg4CGR2D7kSs0v4LLanw2qksYuRlEzO+tcaEPQogQ0KaoGN26/zrn20ImR1DfuLWnOo7aBA=="
      crossorigin="anonymous"
      referrerpolicy="no-referrer"
    />
    <link
      href="https://fonts.googleapis.com/css2?family=Radley&display=swap"
      rel="stylesheet"
    />
  </head>
  <body>
  <nav class="navbar">
    <div class="logo-title">
        <a href="<?= base_url('web/index') ?>" class="logo-title-link">
            <div class="logo">
                <img src="<?= base_url('asset/website/img/'); ?>logo.png" alt="Logo Paroki Santa Maria Blitar" />
            </div>
            <div class="title">Paroki Santa Maria Blitar</div>
        </a>
    </div>
    <div class="menu-container">
        <button class="hamburger" aria-label="Toggle Menu">
            <span></span>
            <span></span>
            <span></span>
        </button>
        <ul class="nav-menu">
            <li><a href="<?= base_url('web/artikel')?>">Artikel</a></li>
            <li class="has-submenu">
                <a href="#">Pelayanan <span class="arrow">▼</span></a>
                <ul class="dropdown">
                    <li><a href="<?= base_url('web/baptis_balita')?>">Baptis Balita</a></li>
                    <li><a href="<?= base_url('web/baptis_dewasa')?>">Baptis Dewasa</a></li>
                    <li><a href="<?= base_url('web/baptis_lansia')?>">Baptis Lansia</a></li>
                    <li><a href="<?= base_url('web/tobat')?>">Tobat</a></li>
                    <li><a href="<?= base_url('web/komuni_pertama')?>">Komuni Pertama</a></li>
                    <li><a href="<?= base_url('web/krisma')?>">Krisma</a></li>
                    <li><a href="<?= base_url('web/pernikahan')?>">Pernikahan</a></li>
                    <li><a href="<?= base_url('web/pengurapan_orang_sakit')?>">Pengurapan Orang Sakit</a></li>
                </ul>
            </li>
            <li class="has-submenu">
                <a href="#">Informasi <span class="arrow">▼</span></a>
                <ul class="dropdown">
                    <li><a href="<?= base_url('web/pengumuman')?>">Pengumuman</a></li>
                    <li><a href="<?= base_url('web/pastoral')?>">Pastoral</a></li>
                    <li><a href="<?= base_url('web/sekretariat')?>">Sekretariat</a></li>
                    <li><a href="<?= base_url('web/tentang_paroki')?>">Tentang Paroki</a></li>
                    <li><a href="<?= base_url('web/tentang_lingkungan')?>">Tentang Lingkungan</a></li>
                    <li><a href="<?= base_url('web/tentang_stasi')?>">Tentang Stasi</a></li>
                    <li><a href="<?= base_url('web/dpp_bgkp')?>">DPP & BGKP</a></li>
                    <li><a href="<?= base_url('web/kelompok_kategorial')?>">Kelompok Kategorial</a></li>
                    <li><a href="<?= base_url('web/fasilitas')?>">Fasilitas</a></li>
                    <li><a href="<?= base_url('web/peta')?>">Peta</a></li>
                </ul>
            </li>
            <li class="has-submenu">
                <a href="#">Liturgi <span class="arrow">▼</span></a>
                <ul class="dropdown">
                <li><a href="#">Jadwal Misa</a></li>
                    <li><a href="<?= base_url('web/sektretariat')?>">Renungan</a></li>
                    <li><a href="<?= base_url('web/sektretariat')?>">Partitur</a></li>
                    <li><a href="#">Kumpulan Doa</a></li>
                    <li><a href="#">Tata Perayaan Ekaristi</a></li>
                    <li><a href="#">Pelayan Liturgi</a></li>
                </ul>
            </li>
            <li><a href="https://gm.parokisanmarblitar.com/">Goa Maria</a></li>
            <li><a href="#">Tentang Kami</a></li>
            <li class="has-submenu">
                <?php if ($this->session->userdata('email')): ?>
                    <a href="#" aria-label="User Menu"><i class="fas fa-user"></i></a>
                    <ul class="dropdown">
                        <li><a href="<?= base_url('user'); ?>">Dashboard</a></li>
                        <li><a href="<?= base_url('web/logout'); ?>">Logout</a></li>
                    </ul>
                <?php else: ?>
                    <a href="#" id="openLoginModal" aria-label="User Login"><i class="fas fa-user"></i></a>
                <?php endif; ?>
            </li>
        </ul>
    </div>
</nav>
    <!-- Modal Login -->
    <div class="modal" id="loginModal" tabindex="-1" aria-hidden="true">
      <div class="modal-content">
        <button class="close" aria-label="Close Modal">×</button>
        <!-- Tampilan Awal: Pilihan Tombol -->
        <div class="modal-choice" id="modalChoice">
          <h2>Pilih Login</h2>
          <button class="choice-btn" id="loginFormBtn">
            Login Dasboard WEBSite
          </button>
          <button class="choice-btn" id="externalLinkBtn">
            Login Dasboard Data Umat
          </button>
        </div>
        <!-- Tampilan Form Login -->
        <div class="modal-login" id="modalLogin" style="display: none">
          <h2>Login</h2>
          <?= $this->session->flashdata('message'); ?>
          <form  class="user" method="post" action="<?= base_url('web/login'); ?>">
            <label for="username">Username:</label>
            <input type="text" class="form-control form-control-user" id="email"
                                            name="email" placeholder="Enter Email Address..."
                                            value="<?= set_value('email') ?>"><?= form_error('email', '<small class="text-danger pl-3">', '</small>'); ?>
                                   <label for="password">Password:</label>
                                   <input type="password" class="form-control form-control-user" id="password"
                                            name="password" placeholder="Password">
                                        <?= form_error('password', '<small class="text-danger pl-3">', '</small>'); ?>
                                   <button type="submit">Login</button>
          </form>
        </div>
      </div>
    </div>
