<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-4 text-gray-800"><?= $title; ?></h1>
    <div class="row">
        <div class="col-lg">
            <form action="<?= base_url('d_sejarah/edit/' . $sejarah['id']); ?>" method="post" enctype="multipart/form-data">
                <div class="form-group">
                    <label for="tanggal_penulisan">Tanggal Penulisan</label>
                    <input type="text" class="form-control" id="tanggal_penulisan" value="<?= date('d F Y', strtotime($sejarah['tanggal_penulisan'])); ?>" disabled>
                </div>
                <div class="form-group">
                    <label for="tahun">Tahun</label>
                    <input type="text" class="form-control" id="tahun" name="tahun" value="<?= html_escape($sejarah['tahun']); ?>" required>
                </div>
                <div class="form-group">
                    <label for="kategori">Kategori</label>
                    <select class="form-control" id="kategori" name="kategori" required>
                        <option value="">-- Pilih Kategori --</option>
                        <?php foreach ($kategori_list as $kat) : ?>
                            <option value="<?= html_escape($kat['kategori_format']); ?>" <?= $sejarah['kategori'] == $kat['kategori_format'] ? 'selected' : ''; ?>>
                                <?= html_escape($kat['kategori_format']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="isi">Isi</label>
                    <textarea class="form-control" id="isi" name="isi" rows="5" required><?= html_escape($sejarah['isi']); ?></textarea>
                </div>
                <div class="form-group">
                    <label for="gambar_sejarah">Gambar Sejarah (opsional)</label>
                    <input type="file" class="form-control-file" id="gambar_sejarah" name="gambar_sejarah">
                    <?php if ($sejarah['gambar_sejarah']) : ?>
                        <small class="form-text text-muted">Gambar saat ini:</small>
                        <img src="<?= base_url('asset/img/sejarah/') . $sejarah['gambar_sejarah']; ?>" class="img-fluid mt-2" style="max-width: 200px;" alt="Preview Gambar Sejarah">
                    <?php endif; ?>
                </div>
                <button type="submit" class="btn btn-primary">Simpan</button>
                <a href="<?= base_url('d_sejarah'); ?>" class="btn btn-secondary">Kembali</a>
            </form>
        </div>
    </div>
</div>