<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pengumuman_model extends CI_Model {
    private $table = 'pengumuman_db';

    public function get_latest_pengumuman($limit = 12) { // Ubah limit menjadi 12
        $this->db->select('*');
        $this->db->from($this->table);
        $this->db->where('role', 1); // Hanya tampilkan pengumuman dengan role = 1 (publik)
        $this->db->order_by('tanggal_terbit', 'DESC'); // Urutkan berdasarkan tanggal terbit
        $this->db->limit($limit); // Batasi 12 pengumuman
        $query = $this->db->get();
        return $query->result_array();
    }

    // Fungsi lain tetap sama
    public function getPengumuman($search = null, $status = null) {
        $this->db->order_by('id', 'DESC');
        if ($search) {
            $this->db->like('judul', $search);
            $this->db->or_like('tanggal_kegiatan', $search);
            $this->db->or_like('jam_kegiatan', $search);
            $this->db->or_like('tempat_kegiatan', $search);
            $this->db->or_like('panitia', $search);
            $this->db->or_like('kategori', $search);
            $this->db->or_like('deskripsi', $search);
        }
        if ($status == 'pending') {
            $this->db->where('role', 0);
        } elseif ($status == 'public') {
            $this->db->where('role', 1);
        }
        return $this->db->get($this->table)->result_array();
    }

    public function getPengumumanByUser($user_id, $search = null, $status = null) {
        $this->db->where('user_id', $user_id);
        $this->db->order_by('id', 'DESC');
        if ($search) {
            $this->db->like('judul', $search);
            $this->db->or_like('tanggal_kegiatan', $search);
            $this->db->or_like('jam_kegiatan', $search);
            $this->db->or_like('tempat_kegiatan', $search);
            $this->db->or_like('panitia', $search);
            $this->db->or_like('kategori', $search);
            $this->db->or_like('deskripsi', $search);
        }
        if ($status == 'pending') {
            $this->db->where('role', 0);
        } elseif ($status == 'public') {
            $this->db->where('role', 1);
        }
        return $this->db->get($this->table)->result_array();
    }

}