<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Doa_modal extends CI_Model {

    public function getDoa($search = null, $status = null) {
        $this->db->order_by('id', 'DESC');

        if ($search) {
            $this->db->like('judul', $search);
            $this->db->or_like('doa', $search);
            $this->db->or_like('referensi', $search);
            $this->db->or_like('kategori_doa', $search);
        }

        if ($status == 'pending') {
            $this->db->where('role', 0);
        } elseif ($status == 'public') {
            $this->db->where('role', 1);
        }

        return $this->db->get('doa_db')->result_array();
    }

    public function getDoaByUser($id_user, $search = null, $status = null) {
        $this->db->where('id_user', $id_user);
        $this->db->order_by('id', 'DESC');

        if ($search) {
            $this->db->like('judul', $search);
            $this->db->or_like('doa', $search);
            $this->db->or_like('referensi', $search);
            $this->db->or_like('kategori_doa', $search);
        }

        if ($status == 'pending') {
            $this->db->where('role', 0);
        } elseif ($status == 'public') {
            $this->db->where('role', 1);
        }

        return $this->db->get('doa_db')->result_array();
    }
}