<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Artikel_model extends CI_Model {
    private $table = 'artikel_db';

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    public function getArtikel($search = null, $status = null) {
        $this->db->from($this->table);
        $this->db->order_by('tanggal', 'DESC');

        if ($search !== null && trim($search) !== '') {
            $this->db->group_start();
            $this->db->like('judul', $search);
            $this->db->or_like('isi', $search);
            $this->db->or_like('kategori', $search);
            $this->db->group_end();
        }

        if ($status === 'pending') {
            $this->db->where('role', 0);
        } elseif ($status === 'public') {
            $this->db->where('role', 1);
        }

        return $this->db->get()->result_array();
    }

    public function getArtikelByUser($id_user, $search = null, $status = null) {
        $this->db->from($this->table);
        $this->db->where('id_user', $id_user);
        $this->db->order_by('tanggal', 'DESC');

        if ($search !== null && trim($search) !== '') {
            $this->db->group_start();
            $this->db->like('judul', $search);
            $this->db->or_like('isi', $search);
            $this->db->or_like('kategori', $search);
            $this->db->group_end();
        }

        if ($status === 'pending') {
            $this->db->where('role', 0);
        } elseif ($status === 'public') {
            $this->db->where('role', 1);
        }

        return $this->db->get()->result_array();
    }

    public function getArtikelById($id) {
        $this->db->where('id', $id);
        return $this->db->get($this->table)->row_array();
    }

    public function insertArtikel($data) {
        return $this->db->insert($this->table, $data);
    }

    public function updateArtikel($id, $data) {
        $this->db->where('id', $id);
        return $this->db->update($this->table, $data);
    }

    public function deleteArtikel($id) {
        $this->db->where('id', $id);
        return $this->db->delete($this->table);
    }

    public function get_latest_artikel($limit = 10, $offset = 0, $search = null) {
        $this->db->from($this->table);
        $this->db->where('role', 1); // Hanya artikel publik

        if ($search !== null && trim($search) !== '') {
            $this->db->group_start();
            $this->db->like('judul', $search);
            $this->db->or_like('isi', $search);
            $this->db->or_like('kategori', $search);
            $this->db->group_end();
        }

        $this->db->order_by('tanggal', 'DESC');
        $this->db->limit($limit, $offset);
        return $this->db->get()->result_array();
    }

    public function count_artikel($search = null) {
        $this->db->from($this->table);
        $this->db->where('role', 1); // Hanya artikel publik

        if ($search !== null && trim($search) !== '') {
            $this->db->group_start();
            $this->db->like('judul', $search);
            $this->db->or_like('isi', $search);
            $this->db->or_like('kategori', $search);
            $this->db->group_end();
        }

        return $this->db->count_all_results();
    }

    public function get_artikel_by_id($id) {
        $this->db->from($this->table);
        $this->db->where('id', $id);
        $this->db->where('role', 1); // Hanya artikel publik
        return $this->db->get()->row_array();
    }

    
}