<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Web extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->library('session');
        $this->load->library('pagination');
        $this->load->model('Pengumuman_model');
        $this->load->model('Artikel_model');
    }

    public function index() {
        $search = $this->input->get('search');
        $data['pengumuman'] = $this->Pengumuman_model->get_latest_pengumuman(7);
        $data['artikel'] = $this->Artikel_model->get_latest_artikel(5, 0, $search);
        $data['title'] = 'Halaman Utama - Pengumuman';
        $data['search'] = $search;
        $this->load->view('template_web/header', $data);
        $this->load->view('web/index', $data);
        $this->load->view('template_web/footer');
    }

    public function artikel() {
        $search = $this->input->get('search');
        $page = $this->input->get('page') ? $this->input->get('page') : 1;
        $limit = 10;
        $offset = ($page - 1) * $limit;

        $total_artikel = $this->Artikel_model->count_artikel($search);
        $total_pages = ceil($total_artikel / $limit);

        $config['base_url'] = base_url('web/artikel');
        $config['total_rows'] = $total_artikel;
        $config['per_page'] = $limit;
        $config['use_page_numbers'] = TRUE;
        $config['page_query_string'] = TRUE;
        $config['query_string_segment'] = 'page';
        $config['enable_query_strings'] = TRUE;
        $config['reuse_query_string'] = TRUE;

        $config['full_tag_open'] = '<div class="pagination">';
        $config['full_tag_close'] = '</div>';
        $config['first_link'] = '« First';
        $config['last_link'] = 'Last »';
        $config['next_link'] = 'Next';
        $config['prev_link'] = 'Prev';
        $config['cur_tag_open'] = '<span class="current">';
        $config['cur_tag_close'] = '</span>';
        $config['num_tag_open'] = '<span>';
        $config['num_tag_close'] = '</span>';

        $this->pagination->initialize($config);

        $data['artikel'] = $this->Artikel_model->get_latest_artikel($limit, $offset, $search);
        $data['pengumuman'] = $this->Pengumuman_model->get_latest_pengumuman(7);
        $data['title'] = 'Halaman Utama - Artikel';
        $data['search'] = $search;
        $data['pagination'] = $this->pagination->create_links();
        $data['current_page'] = $page;
        $data['total_pages'] = $total_pages;

        $this->load->view('template_web/header', $data);
        $this->load->view('web/artikel', $data);
        $this->load->view('template_web/footer');
    }

    public function detail_artikel($id) {
        $data['artikel'] = $this->Artikel_model->get_artikel_by_id($id);

        if (empty($data['artikel'])) {
            show_404();
        }

        $data['title'] = htmlspecialchars($data['artikel']['judul']) . ' - Detail Artikel';
        $data['pengumuman'] = $this->Pengumuman_model->get_latest_pengumuman(7);

        $this->load->view('template_web/header', $data);
        $this->load->view('web/detail_artikel', $data);
        $this->load->view('template_web/footer');
    }

    public function login() {
        $email = $this->input->post('email');
        $password = $this->input->post('password');
        $user = $this->db->get_where('user', ['email' => $email])->row_array();
        $response = [];
        if ($user) {
            if ($user['is_active'] == 1) {
                if (password_verify($password, $user['password'])) {
                    $data = ['email' => $user['email'], 'role_id' => $user['role_id']];
                    $this->session->set_userdata($data);
                    $response = [
                        'success' => true,
                        'redirect' => $user['role_id'] == 1 ? base_url('admin') : base_url('user')
                    ];
                } else {
                    $response = ['success' => false, 'message' => 'Password salah!'];
                }
            } else {
                $response = ['success' => false, 'message' => 'Email belum diaktifkan!'];
            }
        } else {
            $response = ['success' => false, 'message' => 'Email tidak terdaftar!'];
        }
        $this->output->set_content_type('application/json')->set_output(json_encode($response));
    }

    public function logout() {
        $this->session->unset_userdata('email');
        $this->session->unset_userdata('role_id');
        $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">You have been logged out!</div>');
        redirect('web');
    }


    public function baptis_balita() {
        $search = $this->input->get('search');
        $data['pengumuman'] = $this->Pengumuman_model->get_latest_pengumuman(7);
        $data['artikel'] = $this->Artikel_model->get_latest_artikel(5, 0, $search);
        $data['title'] = 'Halaman Utama - Pengumuman';
        $data['search'] = $search;
        $this->load->view('template_web/header', $data);
        $this->load->view('web/layanan/baptis_balita', $data);
        $this->load->view('web/layanan/style_layanan');
        $this->load->view('template_web/footer');
    }

    public function baptis_dewasa() {
        $search = $this->input->get('search');
        $data['pengumuman'] = $this->Pengumuman_model->get_latest_pengumuman(7);
        $data['artikel'] = $this->Artikel_model->get_latest_artikel(5, 0, $search);
        $data['title'] = 'Halaman Utama - Pengumuman';
        $data['search'] = $search;
        $this->load->view('template_web/header', $data);
        $this->load->view('web/layanan/baptis_dewasa', $data);
        $this->load->view('web/layanan/style_layanan');
        $this->load->view('template_web/footer');
    }

    public function baptis_lansia() {
        $search = $this->input->get('search');
        $data['pengumuman'] = $this->Pengumuman_model->get_latest_pengumuman(7);
        $data['artikel'] = $this->Artikel_model->get_latest_artikel(5, 0, $search);
        $data['title'] = 'Halaman Utama - Pengumuman';
        $data['search'] = $search;
        $this->load->view('template_web/header', $data);
        $this->load->view('web/layanan/baptis_lansia', $data);
        $this->load->view('web/layanan/style_layanan');
        $this->load->view('template_web/footer');
    }

    public function tobat() {
        $search = $this->input->get('search');
        $data['pengumuman'] = $this->Pengumuman_model->get_latest_pengumuman(7);
        $data['artikel'] = $this->Artikel_model->get_latest_artikel(5, 0, $search);
        $data['title'] = 'Halaman Utama - Pengumuman';
        $data['search'] = $search;
        $this->load->view('template_web/header', $data);
        $this->load->view('web/layanan/tobat', $data);
        $this->load->view('web/layanan/style_layanan');
        $this->load->view('template_web/footer');
    }

    public function komuni_pertama() {
        $search = $this->input->get('search');
        $data['pengumuman'] = $this->Pengumuman_model->get_latest_pengumuman(7);
        $data['artikel'] = $this->Artikel_model->get_latest_artikel(5, 0, $search);
        $data['title'] = 'Halaman Utama - Pengumuman';
        $data['search'] = $search;
        $this->load->view('template_web/header', $data);
        $this->load->view('web/layanan/komuni_pertama', $data);
        $this->load->view('web/layanan/style_layanan');
        $this->load->view('template_web/footer');
    }

    public function krisma() {
        $search = $this->input->get('search');
        $data['pengumuman'] = $this->Pengumuman_model->get_latest_pengumuman(7);
        $data['artikel'] = $this->Artikel_model->get_latest_artikel(5, 0, $search);
        $data['title'] = 'Halaman Utama - Pengumuman';
        $data['search'] = $search;
        $this->load->view('template_web/header', $data);
        $this->load->view('web/layanan/krisma', $data);
        $this->load->view('web/layanan/style_layanan');
        $this->load->view('template_web/footer');
    }

    public function pernikahan() {
        $search = $this->input->get('search');
        $data['pengumuman'] = $this->Pengumuman_model->get_latest_pengumuman(7);
        $data['artikel'] = $this->Artikel_model->get_latest_artikel(5, 0, $search);
        $data['title'] = 'Halaman Utama - Pengumuman';
        $data['search'] = $search;
        $this->load->view('template_web/header', $data);
        $this->load->view('web/layanan/pernikahan', $data);
        $this->load->view('web/layanan/style_layanan');
        $this->load->view('template_web/footer');
    }
  
    public function pengurapan_orang_sakit() {
        $search = $this->input->get('search');
        $data['pengumuman'] = $this->Pengumuman_model->get_latest_pengumuman(7);
        $data['artikel'] = $this->Artikel_model->get_latest_artikel(5, 0, $search);
        $data['title'] = 'Halaman Utama - Pengumuman';
        $data['search'] = $search;
        $this->load->view('template_web/header', $data);
        $this->load->view('web/layanan/pengurapan_orang_sakit', $data);
        $this->load->view('web/layanan/style_layanan');
        $this->load->view('template_web/footer');
    }
  
/*-------------------------- Pusat Informasi --------------------------*/

    public function pengumuman() {
        $search = $this->input->get('search');
        $data['pengumuman'] = $this->Pengumuman_model->get_latest_pengumuman(7);
        $data['artikel'] = $this->Artikel_model->get_latest_artikel(5, 0, $search);
        $data['search'] = $search;
        $this->load->view('template_web/header', $data);
        $this->load->view('web/informasi/pengumuman', $data);
        $this->load->view('template_web/footer');
    }

    public function pastoral() {
        $search = $this->input->get('search');
       $data['search'] = $search;
        $this->load->view('template_web/header', $data);
        $this->load->view('web/informasi/pastoral', $data);
        $this->load->view('template_web/footer');
    }

    public function sekretariat() {
        $search = $this->input->get('search');
       $data['search'] = $search;
        $this->load->view('template_web/header', $data);
        $this->load->view('web/informasi/sekretariat', $data);
        $this->load->view('template_web/footer');
    }

    public function tentang_paroki() {
        $search = $this->input->get('search');
       $data['search'] = $search;
        $this->load->view('template_web/header', $data);
        $this->load->view('web/informasi/tentang_paroki', $data);
        $this->load->view('template_web/footer');
    }

    public function tentang_lingkungan() {
        $search = $this->input->get('search');
       $data['search'] = $search;
        $this->load->view('template_web/header', $data);
        $this->load->view('web/informasi/tentang_lingkungan', $data);
        $this->load->view('template_web/footer');
    }

    public function tentang_stasi() {
        $search = $this->input->get('search');
       $data['search'] = $search;
        $this->load->view('template_web/header', $data);
        $this->load->view('web/informasi/tentang_stasi', $data);
        $this->load->view('template_web/footer');
    }

    public function dpp_bgkp() {
        $search = $this->input->get('search');
       $data['search'] = $search;
        $this->load->view('template_web/header', $data);
        $this->load->view('web/informasi/dpp_bgkp', $data);
        $this->load->view('template_web/footer');
    }

    public function fasilitas() {
        $search = $this->input->get('search');
       $data['search'] = $search;
        $this->load->view('template_web/header', $data);
        $this->load->view('web/informasi/fasilitas', $data);
        $this->load->view('template_web/footer');
    }

    public function peta() {
        $search = $this->input->get('search');
       $data['search'] = $search;
        $this->load->view('template_web/header', $data);
        $this->load->view('web/informasi/peta', $data);
        $this->load->view('template_web/footer');
    }
 
    public function kelompok_kategorial() {
        $search = $this->input->get('search');
       $data['search'] = $search;
        $this->load->view('template_web/header', $data);
        $this->load->view('web/informasi/kelompok_kategorial', $data);
        $this->load->view('template_web/footer');
    }

}