<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class D_Pengumuman extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->library('session');
        $this->load->model('Pengumuman_model', 'pengumuman');

        if (!$this->session->userdata('email')) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Silakan login terlebih dahulu!</div>');
            redirect('auth');
        }
    }

    public function index() {
        $data['title'] = 'Pengumuman';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();

        if (!$data['user']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Pengguna tidak ditemukan! Silakan login ulang.</div>');
            redirect('auth');
        }

        $search = $this->input->get('search');
        $status = $this->input->get('status');

        if ($data['user']['role_id'] == 1) {
            $data['pengumuman'] = $this->pengumuman->getPengumuman($search, $status);
        } else {
            $data['pengumuman'] = $this->pengumuman->getPengumumanByUser($data['user']['id'], $search, $status);
        }

        $data['kategori'] = $this->db->get('kategori_pengumuman')->result_array();

        $this->form_validation->set_rules('judul', 'Judul', 'required');
        $this->form_validation->set_rules('tanggal_kegiatan', 'Tanggal Kegiatan', 'required');
        $this->form_validation->set_rules('jam_kegiatan', 'Jam Kegiatan', 'required');
        $this->form_validation->set_rules('tempat_kegiatan', 'Tempat Kegiatan', 'required');
        $this->form_validation->set_rules('panitia', 'Panitia', 'required');
        $this->form_validation->set_rules('kontak_cs', 'Kontak CS', 'required');
        $this->form_validation->set_rules('kategori', 'Kategori', 'required');
        $this->form_validation->set_rules('deskripsi', 'Deskripsi', 'required');

        if ($this->form_validation->run() == false && !$this->input->post()) {
            $this->load->view('template/user_header', $data);
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topbar', $data);
            $this->load->view('d_pengumuman/index', $data);
            $this->load->view('template/user_footer');
        } else {
            $upload_image = $_FILES['gambar']['name'];
            if ($upload_image) {
                $ext = pathinfo($upload_image, PATHINFO_EXTENSION);
                $nama_foto = basename($upload_image, '.' . $ext);
                $nama_foto_baru = $nama_foto . '_' . time() . '.' . $ext;

                $config['upload_path'] = './asset/img/pengumuman/';
                $config['allowed_types'] = 'gif|jpg|png';
                $config['max_size'] = 12048; // 12MB
                $config['file_name'] = $nama_foto_baru;
                $config['overwrite'] = TRUE;

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('gambar')) {
                    $new_img = $this->upload->data('file_name');
                } else {
                    $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal mengunggah gambar: ' . $this->upload->display_errors() . '</div>');
                    redirect('d_pengumuman');
                }
            } else {
                $new_img = null;
            }

            $data_insert = [
                'judul' => $this->input->post('judul'),
                'tanggal_kegiatan' => $this->input->post('tanggal_kegiatan'),
                'jam_kegiatan' => $this->input->post('jam_kegiatan'),
                'tempat_kegiatan' => $this->input->post('tempat_kegiatan'),
                'reservasi_fasilitas' => $this->input->post('reservasi_fasilitas'),
                'panitia' => $this->input->post('panitia'),
                'kontak_cs' => $this->input->post('kontak_cs'),
                'kategori' => $this->input->post('kategori'),
                'deskripsi' => $this->input->post('deskripsi'),
                'upload_gambar' => $new_img,
                'role' => 0,
                'user_id' => $data['user']['id'],
                'tanggal_terbit' => date('Y-m-d H:i:s')
            ];

            if ($this->db->insert('pengumuman_db', $data_insert)) {
                $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Pengumuman berhasil ditambahkan!</div>');
            } else {
                $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal menyimpan pengumuman!</div>');
            }
            redirect('d_pengumuman');
        }
    }

    public function publish($id) {
        $user = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        if ($user['role_id'] != 1) {
            redirect('d_pengumuman');
        }

        $this->db->set('role', 1);
        $this->db->where('id', $id);
        $this->db->update('pengumuman_db');

        $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Pengumuman berhasil dipublikasikan!</div>');
        redirect('d_pengumuman');
    }

    public function delete($id) {
        $pengumuman = $this->db->get_where('pengumuman_db', ['id' => $id])->row_array();

        if ($pengumuman) {
            if ($pengumuman['upload_gambar'] && file_exists(FCPATH . 'asset/img/pengumuman/' . $pengumuman['upload_gambar'])) {
                unlink(FCPATH . 'asset/img/pengumuman/' . $pengumuman['upload_gambar']);
            }

            $this->db->where('id', $id);
            $this->db->delete('pengumuman_db');

            $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Pengumuman berhasil dihapus!</div>');
        } else {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Pengumuman tidak ditemukan!</div>');
        }
        redirect('d_pengumuman');
    }

    public function add_kategori() {
        $user = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        if ($user['role_id'] != 1) {
            redirect('d_pengumuman');
        }

        $this->form_validation->set_rules('kategori', 'Kategori', 'required|trim');

        if ($this->form_validation->run() == false) {
            redirect('d_pengumuman');
        } else {
            $kategori = $this->input->post('kategori', true);
            $data = [
                'nama' => htmlspecialchars($kategori),
                'role' => 1
            ];

            $this->db->insert('kategori_pengumuman', $data);
            $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Kategori berhasil ditambahkan!</div>');
            redirect('d_pengumuman');
        }
    }

    public function edit($id) {
        $data['title'] = 'Edit Pengumuman';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['pengumuman'] = $this->db->get_where('pengumuman_db', ['id' => $id])->row_array();
        $data['kategori'] = $this->db->get('kategori_pengumuman')->result_array();

        if (!$data['pengumuman']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Pengumuman tidak ditemukan!</div>');
            redirect('d_pengumuman');
        }

        // Sesuaikan aturan validasi dengan field yang ada di form
        $this->form_validation->set_rules('judul', 'Judul', 'required');
        $this->form_validation->set_rules('tanggal_kegiatan', 'Tanggal Kegiatan', 'required');
        $this->form_validation->set_rules('jam_kegiatan', 'Jam Kegiatan', 'required');
        $this->form_validation->set_rules('tempat_kegiatan', 'Tempat Kegiatan', 'required');
        $this->form_validation->set_rules('kontak_cs', 'Kontak CS', 'required');
        $this->form_validation->set_rules('kategori', 'Kategori', 'required');
        // Hapus validasi untuk 'panitia' dan 'deskripsi' karena tidak ada di form
        // $this->form_validation->set_rules('panitia', 'Panitia', 'required');
        // $this->form_validation->set_rules('deskripsi', 'Deskripsi', 'required');

        if ($this->form_validation->run() == false) {
            $this->load->view('template/user_header', $data);
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topbar', $data);
            $this->load->view('d_pengumuman/edit', $data);
            $this->load->view('template/user_footer');
        } else {
            $upload_image = $_FILES['gambar']['name'];
            if ($upload_image) {
                $ext = pathinfo($upload_image, PATHINFO_EXTENSION);
                $nama_foto = basename($upload_image, '.' . $ext);
                $nama_foto_baru = $nama_foto . '_' . time() . '.' . $ext;

                $config['upload_path'] = './asset/img/pengumuman/';
                $config['allowed_types'] = 'gif|jpg|png';
                $config['max_size'] = 12048;
                $config['file_name'] = $nama_foto_baru;
                $config['overwrite'] = TRUE;

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('gambar')) {
                    $old_image = $data['pengumuman']['upload_gambar'];
                    if ($old_image && file_exists(FCPATH . 'asset/img/pengumuman/' . $old_image)) {
                        unlink(FCPATH . 'asset/img/pengumuman/' . $old_image);
                    }
                    $new_img = $this->upload->data('file_name');
                } else {
                    $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal mengunggah gambar: ' . $this->upload->display_errors() . '</div>');
                    redirect('d_pengumuman/edit/' . $id);
                }
            } else {
                $new_img = $data['pengumuman']['upload_gambar'] ?? ''; // Gunakan gambar lama atau string kosong
            }

            $data_update = [
                'judul' => $this->input->post('judul'),
                'tanggal_kegiatan' => $this->input->post('tanggal_kegiatan'),
                'jam_kegiatan' => $this->input->post('jam_kegiatan'),
                'tempat_kegiatan' => $this->input->post('tempat_kegiatan'),
                'reservasi_fasilitas' => $this->input->post('reservasi_fasilitas') ?? '',
                'kontak_cs' => $this->input->post('kontak_cs'),
                'kategori' => $this->input->post('kategori'),
                'upload_gambar' => $new_img,
                'role' => 0,
                'tanggal_terbit' => date('Y-m-d H:i:s')
            ];

            $this->db->where('id', $id);
            if ($this->db->update('pengumuman_db', $data_update)) {
                $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Pengumuman berhasil diperbarui!</div>');
                redirect('d_pengumuman');
            } else {
                $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal memperbarui pengumuman!</div>');
                redirect('d_pengumuman/edit/' . $id);
            }
        }
    }
}