<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class D_Pelayan_pastoral extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->library('session');
        $this->load->model('Pelayan_pastoral_model', 'pelayan');

        if (!$this->session->userdata('email')) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Silakan login terlebih dahulu!</div>');
            redirect('auth');
        }
    }

    public function index() {
        $data['title'] = 'Pelayanan Pastoral';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();

        if (!$data['user']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Pengguna tidak ditemukan! Silakan login ulang.</div>');
            redirect('auth');
        }

        $search = $this->input->get('search');
        $status = $this->input->get('status');

        if ($data['user']['role_id'] == 1) {
            $data['pelayan'] = $this->pelayan->getPelayan($search, $status);
        } else {
            $data['pelayan'] = $this->pelayan->getPelayanByUser($data['user']['id'], $search, $status);
        }

        $this->form_validation->set_rules('nama_lengkap', 'Nama Lengkap', 'required');
        $this->form_validation->set_rules('jabatan', 'Jabatan', 'required');
        $this->form_validation->set_rules('tanggal_mulai', 'Tanggal Mulai', 'required');

        if ($this->form_validation->run() == false && !$this->input->post()) {
            $this->load->view('template/user_header', $data);
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topbar', $data);
            $this->load->view('d_pelayan_pastoral/index', $data);
            $this->load->view('template/user_footer');
        } else {
            $upload_image = $_FILES['link_foto']['name'];
            if ($upload_image) {
                $ext = pathinfo($upload_image, PATHINFO_EXTENSION);
                $nama_foto = basename($upload_image, '.' . $ext);
                $nama_foto_baru = $nama_foto . '_' . time() . '.' . $ext;

                $config['upload_path'] = './asset/img/pelayan_pastoral/';
                $config['allowed_types'] = 'gif|jpg|png';
                $config['max_size'] = 12048; // 12MB
                $config['file_name'] = $nama_foto_baru;
                $config['overwrite'] = TRUE;

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('link_foto')) {
                    $new_img = $this->upload->data('file_name');
                } else {
                    $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal mengunggah foto: ' . $this->upload->display_errors() . '</div>');
                    redirect('d_pelayan_pastoral');
                }
            } else {
                $new_img = null;
            }

            $data_insert = [
                'nama_lengkap' => $this->input->post('nama_lengkap'),
                'jabatan' => $this->input->post('jabatan'),
                'tempat_lahir' => $this->input->post('tempat_lahir'),
                'tarekat' => $this->input->post('tarekat'),
                'tempat_tahbisan' => $this->input->post('tempat_tahbisan'),
                'tanggal_tahbisan' => $this->input->post('tanggal_tahbisan'),
                'tanggal_mulai' => $this->input->post('tanggal_mulai'),
                'tanggal_selesai' => $this->input->post('tanggal_selesai'),
                'deskripsi' => $this->input->post('deskripsi'),
                'link_foto' => $new_img,
                'role' => 0,
            ];

            if ($this->db->insert('pelayan_pastoral_db', $data_insert)) {
                $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data pelayan pastoral berhasil ditambahkan!</div>');
            } else {
                $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal menyimpan data!</div>');
            }
            redirect('d_pelayan_pastoral');
        }
    }

    public function publish($id) {
        $user = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        if ($user['role_id'] != 1) {
            redirect('d_pelayan_pastoral');
        }

        $this->db->set('role', 1);
        $this->db->where('id', $id);
        $this->db->update('pelayan_pastoral_db');

        $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data pelayan pastoral berhasil dipublikasikan!</div>');
        redirect('d_pelayan_pastoral');
    }

    public function delete($id) {
        $pelayan = $this->db->get_where('pelayan_pastoral_db', ['id' => $id])->row_array();

        if ($pelayan) {
            if ($pelayan['link_foto'] && file_exists(FCPATH . 'asset/img/pelayan_pastoral/' . $pelayan['link_foto'])) {
                unlink(FCPATH . 'asset/img/pelayan_pastoral/' . $pelayan['link_foto']);
            }

            $this->db->where('id', $id);
            $this->db->delete('pelayan_pastoral_db');

            $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data pelayan pastoral berhasil dihapus!</div>');
        } else {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Data tidak ditemukan!</div>');
        }
        redirect('d_pelayan_pastoral');
    }

    public function edit($id) {
        $data['title'] = 'Edit Pelayan Pastoral';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['pelayan'] = $this->db->get_where('pelayan_pastoral_db', ['id' => $id])->row_array();

        if (!$data['pelayan']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Data tidak ditemukan!</div>');
            redirect('d_pelayan_pastoral');
        }

        $this->form_validation->set_rules('nama_lengkap', 'Nama Lengkap', 'required');
        $this->form_validation->set_rules('jabatan', 'Jabatan', 'required');
        $this->form_validation->set_rules('tanggal_mulai', 'Tanggal Mulai', 'required');

        if ($this->form_validation->run() == false) {
            $this->load->view('template/user_header', $data);
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topbar', $data);
            $this->load->view('d_pelayan_pastoral/edit', $data);
            $this->load->view('template/user_footer');
        } else {
            $upload_image = $_FILES['link_foto']['name'];
            if ($upload_image) {
                $ext = pathinfo($upload_image, PATHINFO_EXTENSION);
                $nama_foto = basename($upload_image, '.' . $ext);
                $nama_foto_baru = $nama_foto . '_' . time() . '.' . $ext;

                $config['upload_path'] = './asset/img/pelayan_pastoral/';
                $config['allowed_types'] = 'gif|jpg|png';
                $config['max_size'] = 12048;
                $config['file_name'] = $nama_foto_baru;
                $config['overwrite'] = TRUE;

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('link_foto')) {
                    $old_image = $data['pelayan']['link_foto'];
                    if ($old_image && file_exists(FCPATH . 'asset/img/pelayan_pastoral/' . $old_image)) {
                        unlink(FCPATH . 'asset/img/pelayan_pastoral/' . $old_image);
                    }
                    $new_img = $this->upload->data('file_name');
                } else {
                    $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal mengunggah foto: ' . $this->upload->display_errors() . '</div>');
                    redirect('d_pelayan_pastoral/edit/' . $id);
                }
            } else {
                $new_img = $data['pelayan']['link_foto'];
            }

            $data_update = [
                'nama_lengkap' => $this->input->post('nama_lengkap'),
                'jabatan' => $this->input->post('jabatan'),
                'tempat_lahir' => $this->input->post('tempat_lahir'),
                'tarekat' => $this->input->post('tarekat'),
                'tempat_tahbisan' => $this->input->post('tempat_tahbisan'),
                'tanggal_tahbisan' => $this->input->post('tanggal_tahbisan'),
                'tanggal_mulai' => $this->input->post('tanggal_mulai'),
                'tanggal_selesai' => $this->input->post('tanggal_selesai'),
                'deskripsi' => $this->input->post('deskripsi'),
                'link_foto' => $new_img,
                'role' => 0
            ];

            $this->db->where('id', $id);
            if ($this->db->update('pelayan_pastoral_db', $data_update)) {
                $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data pelayan pastoral berhasil diperbarui!</div>');
            } else {
                $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal memperbarui data!</div>');
            }
            redirect('d_pelayan_pastoral');
        }
    }
}